﻿/*
Run this script to update the MET/CONNECT database from 3.5.0 to 3.6.0

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '2.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 2.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.0.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.0.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.1.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.1.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.2.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.2.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.4.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.4.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.5.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.5.0 is missing. ***', 20,-1) WITH LOG
END
GO

-- set database compatibility level to SQL Server 2012
DECLARE @comp NVARCHAR(max);
SET @comp = N'ALTER DATABASE [' + (SELECT DB_NAME()) + ']
SET COMPATIBILITY_LEVEL = 110 '
EXEC sp_executesql @comp
GO

-- No need to process if we have a 3.6.0 version record
IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE nVersionUID = '59952E38-47DB-4097-A1AA-46361233194A' )
BEGIN
	BEGIN TRANSACTION

	-- get the current collation and switch it to case-sensitive
	DECLARE @sql NVARCHAR(max);
	DECLARE @coll_cs NVARCHAR(100);
	SELECT @coll_cs = collation_name FROM sys.databases WHERE name = (SELECT DB_NAME());
	SELECT @coll_cs = REPLACE(@coll_cs, N'CI', N'CS');


	-->>METCON-2840<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'a72e2a36-132c-493b-9809-ba5eb737a7c1')
	BEGIN
		PRINT N'Adding UCI Data'

		INSERT INTO [dbo].[UCIData] ([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],
			[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES ('a72e2a36-132c-493b-9809-ba5eb737a7c1','MET/CAL','Edit Export Settings','Enabled',1,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398',
		'915F9722-3175-4E4D-A571-4A478E8E5172','20220526 18:36:33.827','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172',
		'20220526 18:36:33.827','20220526 18:36:33.827',NULL,NULL);

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE nSecurityGroupFieldLinkUID = '8da1cd22-029e-429d-b141-64d1db057134')
	BEGIN
		PRINT N'Adding Security Group Field Link'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] (nSecurityGroupFieldLinkUID,nSecurityGroupUID,nUCIDataUID,lActive,lDeleted,lApproved,lAdded,
			nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES ('8da1cd22-029e-429d-b141-64d1db057134','FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0','a72e2a36-132c-493b-9809-ba5eb737a7c1',
			-1,0,0,0,'AB9B7878-B72C-4A72-9273-47030571BE4C','ABF8F215-1980-4E47-84DA-305699ECF5D5','20220526 18:36:33.827',
			'AB9B7878-B72C-4A72-9273-47030571BE4C','ABF8F215-1980-4E47-84DA-305699ECF5D5','20220526 18:36:33.827','20220526 18:36:33.827',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-2688<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '654db8d4-5c12-4774-9e5f-f493ae625959')
	BEGIN
		PRINT N'Adding System Default'

		INSERT INTO [dbo].[SystemDefaults] ([nSystemDefaultUID], [cAuthority], [cProperty], [cValue], [nOrder], [cAction], [cGraphic], [mNotes], 
			[lLocal], [lSystemic], [lWarehouse], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], 
			[nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('654db8d4-5c12-4774-9e5f-f493ae625959', N'Default', N'Export Settings', N'(None)', 0, NULL, NULL, 
			N'{}', 0, 0, 0, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20220503 21:03:32', 
			'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20220503 21:03:32', '20220503 21:03:32', NULL, NULL);

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-2668<<--
	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_METCONNECT_RESULTS' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_METCONNECT_RESULTS]'

		DROP VIEW [dbo].vw_METCONNECT_RESULTS

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
		
	IF OBJECT_ID(N'[dbo].[vw_METCONNECT_RESULTS]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_METCONNECT_RESULTS]'

		EXEC sp_executesql N'
	/****************************************************************
		vw_METCONNECT_RESULTS
		(C) 2019-22 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		11/06/2019  MM      Initial development
		11/25/2019  MM      Add cFunctionSelectCode
		11/23/2020  MM      Add Test Step
		02/23/2021  MM      Add Upper and Lower Limit
		03/05/2021  AC      Add FixedQuantity and VariableQuantity
		04/20/2021  MM      Add DUT Resolution
		04/22/2021  MM      Add Group Run Id and Tag Ordinal
		05/02/2022  AC      Add TUR
	*****************************************************************/
	CREATE VIEW [dbo].[vw_METCONNECT_RESULTS]
	AS
		SELECT
			csr.nCallSheetResultUID AS [ResultKey],
			p.nPointUID AS [PointKey],
			p.nPointOrdinal AS [Ordinal],
			p.cPointDescription AS [Description],
			p.cFunctionSelectCode AS [FSC],
			p.cRemarks AS [Remarks],
			p.cPointPassFailStatus AS [Status],
			ISNULL([dbo].[udf_get_formattedValue](p.nCardinalPoint, p.nCardinalPointFormatUID),'''') AS [CardinalPoint],
			up3.cUnitSymbol AS [CardinalPointUnit],
			ISNULL([dbo].[udf_get_formattedValue](p.nReference, p.nReferenceFormatUID),'''') AS [Reference],
			up2.cUnitSymbol AS [ReferenceUnit],
			ISNULL([dbo].[udf_get_formattedValue](p.nUUT, p.nUUTFormatUID),'''') AS [Dut],
			up1.cUnitSymbol AS [DutUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nError, tol.nErrorFormatUID),'''') AS [Error],
			utol1.cUnitSymbol AS [ErrorUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID),'''') AS [ToleranceNegative],
			utol5.cUnitSymbol AS [ToleranceNegativeUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID),'''') AS [TolerancePositive],
			utol6.cUnitSymbol AS [TolerancePositiveUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID),'''') AS [GuardbandLowerLimit],
			upun18.cUnitSymbol AS [GuardbandLowerLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID),'''') AS [GuardbandUpperLimit],
			upun19.cUnitSymbol AS [GuardbandUpperLimitUnit],
			ISNULL(p.cPointPassFailStatus, '''') AS [PointPassFail],
			ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID),'''') AS [ExpandedUncertainty],
			upun3.cUnitSymbol AS [ExpandedUncertaintyUnit],
			ISNULL(pes.cField009,'''') AS [TestStep],
			ISNULL([dbo].[udf_get_formattedValue](pun.nLowerLimit, pun.nLowerLimitFormatUID),'''') AS [LowerLimit],
			upun1.cUnitSymbol AS [LowerLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nUpperLimit, pun.nUpperLimitFormatUID),'''') AS [UpperLimit],
			upun2.cUnitSymbol AS [UpperLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField010, pen.nField010FormatUID),'''') AS [FixedQuantity],
			upen1.cUnitSymbol AS [FixedQuantityUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField029, pen.nField029FormatUID),'''') AS [VariableQuantity],
			upen2.cUnitSymbol AS [VariableQuantityUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField028, pen.nField028FormatUID),'''') AS [DutResolution],
			upen3.cUnitSymbol AS [DutResolutionUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField030, pen.nField030FormatUID),'''') AS [TUR],
			ISNULL(csrx.cField049,'''') AS [ProcedureTagOrdinal],
			ISNULL(csrx.cField050,'''') AS [ProcedureRunId]
		FROM
			[dbo].[CallSheetResults] csr
			INNER JOIN [dbo].[Points] p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN [dbo].[CallSheetResultEx] csrx ON csrx.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN [dbo].[Units] up1 ON up1.nUnitUID = p.nUUTUnitUID
			LEFT JOIN [dbo].[Units] up2 ON up2.nUnitUID = p.nReferenceUnitUID
			LEFT JOIN [dbo].[Units] up3 ON up3.nUnitUID = p.nCardinalPointUnitUID
			LEFT JOIN [dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] upen1 ON upen1.nUnitUID = pen.nField010UnitUID
			LEFT JOIN [dbo].[Units] upen2 ON upen2.nUnitUID = pen.nField029UnitUID
			LEFT JOIN [dbo].[Units] upen3 ON upen3.nUnitUID = pen.nField028UnitUID
			LEFT JOIN [dbo].[PointUncertainties] pun ON pun.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] upun1 ON upun1.nUnitUID = pun.nLowerLimitUnitUID
			LEFT JOIN [dbo].[Units] upun2 ON upun2.nUnitUID = pun.nUpperLimitUnitUID
			LEFT JOIN [dbo].[Units] upun3 ON upun3.nUnitUID = pun.nUncertaintyExpandedUnitUID
			LEFT JOIN [dbo].[Units] upun4 ON upun4.nUnitUID = pun.nUncertaintyStandardUnitUID
			LEFT JOIN [dbo].[Units] upun18 ON upun18.nUnitUID = pun.nGuardBandLowerUnitUID
			LEFT JOIN [dbo].[Units] upun19 ON upun19.nUnitUID = pun.nGuardBandUpperUnitUID
			LEFT JOIN [dbo].[PointTolerances] tol ON tol.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] utol1 ON utol1.nUnitUID = tol.nErrorUnitUID
			LEFT JOIN [dbo].[Units] utol5 ON utol5.nUnitUID = tol.nToleranceNegativeUnitUID
			LEFT JOIN [dbo].[Units] utol6 ON utol6.nUnitUID = tol.nTolerancePositiveUnitUID
			LEFT JOIN [dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
			WHERE
				p.lDeleted = 0
			AND
				p.lActive <> 0
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-6018<<--
	IF OBJECT_ID(N'[dbo].[spl_Types_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Types_DELETE]'
		DROP PROCEDURE [dbo].[spl_Types_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Types_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Types_DELETE]'

		EXEC sp_executesql N'	
/****************************************************************
	spl_Types_DELETE
	Deletes a single record by ID from the Types table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 12/30/2021 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Types_DELETE]

	@nTypeUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT
	
AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nTypeUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''Types'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		''TypeProcedureDefaults TypesEx TypePartsLink '',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT
	
	RETURN @retMsg
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-3991<<--
	IF EXISTS(SELECT * FROM [dbo].[UCIData] WHERE [nUCIDataUID] = 'FF88033D-2703-413E-B50D-65729AA569B8' AND [cValue] = N'Assigned Group')
	BEGIN			
		PRINT 'Updating UCIData Item'
		
		UPDATE 
			[dbo].[UCIData]
		SET 
			[cValue] = N'Assigned Number'
		WHERE 
			[nUCIDataUID] = 'FF88033D-2703-413E-B50D-65729AA569B8' 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END			
	END		


	-->>MTM-6319<<--
	IF OBJECT_ID(N'[dbo].[vw_AssetsWithEx]', 'V') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[vw_AssetsWithEx]'

		DROP VIEW [dbo].[vw_AssetsWithEx]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_AssetsWithEx]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_AssetsWithEx]'

		EXEC sp_executesql N'
/********************************************************************
		vw_AssetsWithEx
		(C) 2013-21 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		10/21/2013	MM	Initial version (from vw_Assets)
		07/21/2014	MM	Fixed casts and quoted identifiers
		03/11/2015	MM	Exclude inactive and deleted EX records
		07/14/2015	MM	Formatting updated
		01/06/2016  MM  Added AssetServices.tMaintDate
		07/27/2020  MM  Join AssetServices - may appear to yield dups
		09/22/2021  MM  COALESCE nullable integer fields
		10/05/2021  MM  Added cAssignedContact, cOptional1, lOptional
		01/06/2022  MM  Added cTyManufacturer
	*****************************************************************/
	CREATE VIEW [dbo].[vw_AssetsWithEx]
	AS
	SELECT
		ass.[nAssetUID],
		ass.[nFacilityUID],
		ass.[nDepartmentUID],
		ass.[nTypeUID],
		ass.[nManufacturerUID],
		ass.[nCategoryUID],
		ass.[nSubCategoryUID],
		ass.[nInventoryByUID],
		ass.[nParentUID],
		ass.[nMaintenanceFacUID],
		ass.[nAssignedFacUID],
		ass.[nAuthorizedFacUID],
		ass.[cBarcode],
		ass.[cID],
		ass.[cSerialNumber],
		ass.[cModelNumber],
		ass.[cPartNumber],
		ass.[cStockNumber],
		ass.[cStatus],
		ass.[cDisposition],
		ass.[cAssignedGroup],
		ass.[cClass],
		ass.[cGroup],
		ass.[cFamily],
		ass.[cStandardType],
		ass.[cDescription],
		ass.[cPhysicalLocation],
		ass.[cWeightUOM],
		ass.[cWeight],
		ass.[cDimension],
		vas.[cServiceName] AS [cNextMaintType],
		vas.[cInterval],
		vas.[cIntervalUOM],
		ass.[nReplacementCost],
		ass.[nItemCost],
		ass.[tInventoryDate],
		ass.[tInServiceDate],
		ass.[tStatusDate],
		ass.[tPurchaseDate],
		vas.[tNextMaintDate],
		ass.[tAssignedGroupDate],
		ass.[tWarrantyDate],
		ass.[mWarrantyInfo],
		ass.[mAccuracy],
		ass.[mUncertaintyNotes],
		ass.[mNotes],
		COALESCE(ass.[lStandard], 0) AS [lStandard],
		COALESCE(ass.[lRecallMaintenanceType], 0) AS [lRecallMaintenanceType],
		COALESCE(ass.[lInAbeyance], 0) AS [lInAbeyance],
		COALESCE(ass.[nAbeyanceInterval], 0) AS [nAbeyanceInterval],
		COALESCE(ass.[nUseCount], 0) AS [nUseCount],
		COALESCE(ass.[nQuantity], 0) AS [nQuantity],
		COALESCE(ass.[lOnSite], 0) AS [lOnSite],
		COALESCE(ass.[lNonTracked], 0) AS [lNonTracked],
		ass.[lActive],
		ass.[lDeleted],
		ass.[lApproved],
		ass.[lAdded],
		ass.[nAddFacilityUID],
		ass.[nAddUserUID],
		ass.[tAddTime],
		ass.[nUpdateFacilityUID],
		ass.[nUpdateUserUID],
		ass.[tUpdateTime],
		ass.[tMobileTime],
		ass.[tSystemUpdateTime],
		''None'' AS [cShipmentStatus],
		fac.[cFacilityName] AS [cFacilityName],
		fac.[cFacilityNumber] AS [cFacilityNumber],
		dep.[cFacilityName] AS [cDepartment],
		dep.[cFacilityNumber] AS [cDepartmentNumber],
		man.[cFacilityName] AS [cManufacturer],
		cat.[cDescription] AS [cCategory],
		scat.[cDescription] AS [cSubCategory],
		usr.[cFirstName] + '' '' + usr.[cLastName] AS [cInventoryBy],
		par.[cBarcode] AS [cParentBarcode],
		par.[cID] AS [cParentID],
		mfac.[cFacilityName] AS [cMaintenanceFacName],
		mfac.[cFacilityNumber] AS [cMaintenanceFacNumber],
		asfac.[cFacilityName] AS [cAssignedFacName],
		asfac.[cFacilityNumber] AS [cAssignedFacNumber],
		aufac.[cFacilityName] AS [cAuthorizedFacName],
		aufac.[cFacilityNumber] AS [cAuthorizedFacNumber],
		CAST (ass.[mWarrantyInfo] AS NTEXT) AS [mWarrantyInfoText],
		CAST (ass.[mAccuracy] AS NTEXT) AS [mAccuracyText],
		CAST (ass.[mUncertaintyNotes] AS NTEXT) AS [mUncertaintyNotesText],
		CAST (ass.[mNotes] AS NTEXT) AS [mNotesText],
		ty.[nTyItemCost],
		ty.[nTyReplacementCost],
		ty.[cTyModelNumber],
		ty.[cTyDescription],
		ty.[cTyPartNumber],
		ty.[cTyStockNumber],
		ty.[cTyAuthority],
		ty.[cTyClass],
		ty.[cTyFamily],
		ty.[cTyWeight],
		ty.[cTyWeightUOM],
		ty.[cTyDimension],
		ty.[cTyArea],
		ty.[mTyAccuracy],
		ty.[mTyUncertaintyNotes],
		ty.[mTyReceivingNotes],
		ty.[mTyNotes],
		ty.[lTyActive],
		ty.[lTyDeleted],
		ex.[cField1],
		ex.[cField2],
		ex.[cField3],
		ex.[cField4],
		ex.[cField5],
		ex.[cField6],
		ex.[cField7],
		ex.[cField8],
		ex.[cField9],
		ex.[cField10],
		ex.[cField11],
		ex.[cField12],
		ex.[cField13],
		ex.[cField14],
		ex.[cField15],
		ex.[cField16],
		ex.[cField17],
		ex.[cField18],
		ex.[cField19],
		ex.[cField20],
		ex.[cField21],
		ex.[cField22],
		ex.[cField23],
		ex.[cField24],
		ex.[cField25],
		ex.[cField26],
		ex.[cField27],
		ex.[cField28],
		ex.[cField29],
		ex.[cField30],
		ex.[cField31],
		ex.[cField32],
		ex.[cField33],
		ex.[cField34],
		ex.[cField35],
		ex.[tField1],
		ex.[tField2],
		ex.[tField3],
		ex.[tField4],
		ex.[tField5],
		ex.[tField6],
		ex.[tField7],
		ex.[tField8],
		ex.[tField9],
		ex.[tField10],
		ex.[nField1],
		ex.[nField2],
		ex.[nField3],
		ex.[nField4],
		ex.[nField5],
		ex.[nField6],
		ex.[nField7],
		ex.[nField8],
		ex.[nField9],
		ex.[nField10],
		COALESCE(ex.[lField1], 0) AS [lField1],
		COALESCE(ex.[lField2], 0) AS [lField2],
		COALESCE(ex.[lField3], 0) AS [lField3],
		COALESCE(ex.[lField4], 0) AS [lField4],
		COALESCE(ex.[lField5], 0) AS [lField5],
		COALESCE(ex.[lField6], 0) AS [lField6],
		COALESCE(ex.[lField7], 0) AS [lField7],
		COALESCE(ex.[lField8], 0) AS [lField8],
		COALESCE(ex.[lField9], 0) AS [lField9],
		COALESCE(ex.[lField10], 0) AS [lField10],
		ex.[mField1],
		ex.[mField2],
		COALESCE(ex.[lActive], 0) AS [lExActive],
		COALESCE(ex.[lDeleted], 0) AS [lExDeleted],
		vas.[tMaintDate],
		ass.cAssignedContact,
		ass.cOptional1,
		ass.lOptional,
		ty.[cTyManufacturer]
	FROM
		Assets ass
	LEFT JOIN AssetEx ex ON ass.nAssetUID = ex.nAssetUID AND ex.lActive <> 0 AND ex.lDeleted = 0
	LEFT JOIN Facilities AS fac ON ass.nFacilityUID = fac.nFacilityUID
	LEFT JOIN vw_Types AS ty ON ass.nTypeUID = ty.nTyTypeUID
	LEFT JOIN Facilities AS man ON ass.nManufacturerUID = man.nFacilityUID
	LEFT JOIN Category AS cat ON ass.nCategoryUID = cat.nCategoryUID
	LEFT JOIN SubCategory AS scat ON ass.nSubCategoryUID = scat.nSubCategoryUID
	LEFT JOIN Users AS usr ON ass.nInventoryByUID = usr.nUserUID
	LEFT JOIN Assets AS par ON ass.nParentUID = par.nAssetUID
	LEFT JOIN Facilities AS mfac ON ass.nMaintenanceFacUID = mfac.nFacilityUID
	LEFT JOIN Facilities AS asfac ON ass.nAssignedFacUID = asfac.nFacilityUID
	LEFT JOIN Facilities AS aufac ON ass.nAuthorizedFacUID = aufac.nFacilityUID
	LEFT JOIN Facilities AS dep ON ass.nDepartmentUID = dep.nFacilityUID
	LEFT JOIN vw_AssetsWithServices vas ON ass.nAssetUID = vas.nAssetUID AND vas.ASV_lActive <> 0 AND vas.ST_lActive <> 0 AND vas.lRecalled <> 0
'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-6539<<--
	IF EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '9C54CEB5-007F-4C68-9F94-44B99B1C7F56')
	BEGIN

		IF NOT EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '9C54CEB5-007F-4C68-9F94-44B99B1C7F56'
		AND mNotes = N'AFFECTS: Login  ACTION: When Active is not checked, users log in to MET/TEAM and Customer Portal using their MET/TEAM username and password.\nFor Windows Authentication, check Active and:\nSet Value = 1 - MET/TEAM uses Windows Authentication and Customer Portal uses MET/TEAM Login\nSet Value = 2 - Both MET/TEAM and Customer Portal use Windows Authentication\nFor SAML2 Authentication, check Active and:\nSet Value = 3 - MET/TEAM uses SAML2 Authentication and Customer Portal uses MET/TEAM Login\nSet Value = 4 - Both MET/TEAM and Customer Portal use SAML2 Authentication\n\nWhen Active and any other Value is entered, both MET/TEAM and Customer Portal use MET/TEAM Login.\n\nATTENTION: If you have activated this System Default, you must set up a user account that matches your domain username (Value = 1 or 2) or SAML2 credentials (Value = 3 or 4) and verify it has administrative rights. Failure to do so may result in being locked out of MET/TEAM!\n\nNOTE: Refer to MET/TEAM help for more information on configuring IIS and MET/TEAM and Customer Portal to support Windows Authentication or SAML2 Authentication.')
		BEGIN
			PRINT N'Updating system default'

			UPDATE [dbo].[SystemDefaults] SET
				mNotes = N'AFFECTS: Login  ACTION: When Active is not checked, users log in to MET/TEAM and Customer Portal using their MET/TEAM username and password.\nFor Windows Authentication, check Active and:\nSet Value = 1 - MET/TEAM uses Windows Authentication and Customer Portal uses MET/TEAM Login\nSet Value = 2 - Both MET/TEAM and Customer Portal use Windows Authentication\nFor SAML2 Authentication, check Active and:\nSet Value = 3 - MET/TEAM uses SAML2 Authentication and Customer Portal uses MET/TEAM Login\nSet Value = 4 - Both MET/TEAM and Customer Portal use SAML2 Authentication\n\nWhen Active and any other Value is entered, both MET/TEAM and Customer Portal use MET/TEAM Login.\n\nATTENTION: If you have activated this System Default, you must set up a user account that matches your domain username (Value = 1 or 2) or SAML2 credentials (Value = 3 or 4) and verify it has administrative rights. Failure to do so may result in being locked out of MET/TEAM!\n\nNOTE: Refer to MET/TEAM help for more information on configuring IIS and MET/TEAM and Customer Portal to support Windows Authentication or SAML2 Authentication.',
				lDeleted = 0,
				tUpdateTime = '20220210 17:42:46.083',
				tMobileTime = '20220210 17:42:46.083',
				tSystemUpdateTime = NULL
			WHERE
				nSystemDefaultUID = '9C54CEB5-007F-4C68-9F94-44B99B1C7F56'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END


	-->>MTM-6703<<--
	-- Update PackageTables records for changes needed for Mobile Check Out and Mobile Check In
	BEGIN
		PRINT N'Updating lApproved and lAdded for all Package Table records'
		UPDATE [dbo].[PackageTables] SET lApproved = -1, lAdded = 0 WHERE nTransferType = 3
		UPDATE [dbo].[PackageTables] SET lApproved = -1, lAdded = 0 WHERE nTransferType = 4

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	BEGIN 
		PRINT N'Updating lActive for Package Table records'
		UPDATE [dbo].[PackageTables] SET lActive = -1 WHERE nPackageTableUID = N'c3d706b1-0e05-4c2f-8597-618bdf63e4f9'
		UPDATE [dbo].[PackageTables] SET lActive = -1 WHERE nPackageTableUID = N'c8015e93-26e4-4e28-8869-f58ae7b7e7de'
		UPDATE [dbo].[PackageTables] SET lActive = -1 WHERE nPackageTableUID = N'c5eace51-8a9c-4867-82de-d69c0a7e4dd6'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	BEGIN 
		PRINT N'Updating lActive and mNotes for Package Table records'
		UPDATE [dbo].[PackageTables] SET lActive = 0, mNotes = N'This feature is not enabled in Mobile' WHERE nPackageTableUID = N'87e4d6e5-a93b-4b13-9f01-f08468f5486c'
		UPDATE [dbo].[PackageTables] SET lActive = 0, mNotes = N'This table is currently not used!' WHERE nPackageTableUID = N'5541108b-eae3-45f0-ab97-0eae8d262ef3'
		UPDATE [dbo].[PackageTables] SET lActive = 0, mNotes = N'This table is currently not used!' WHERE nPackageTableUID = N'dae7b8b8-2027-42a9-be1e-a7be7f78705b'
		UPDATE [dbo].[PackageTables] SET lActive = 0, mNotes = N'Mobile Check In process currently not designed to handle this table' WHERE nPackageTableUID = N'fca84b7d-0faa-4ca8-8514-20005b2ceaea'
		UPDATE [dbo].[PackageTables] SET lActive = 0, mNotes = N'Mobile Check In process currently not designed to handle this table' WHERE nPackageTableUID = N'6cd7ebdb-cd6f-4995-855b-dd464b62b3b5'
		UPDATE [dbo].[PackageTables] SET lActive = 0, mNotes = N'Mobile Check In process currently not designed to handle this table' WHERE nPackageTableUID = N'1e927f96-344e-4c45-a783-e4b6a6f5effd'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	BEGIN 
		PRINT N'Updating mNotes for Package Table records'
		UPDATE [dbo].[PackageTables] SET mNotes = N'This feature is not enabled in Mobile' WHERE nPackageTableUID = N'46c6b896-bca8-4645-b1bd-d95365f4872b'
		UPDATE [dbo].[PackageTables] SET mNotes = N'This feature is not enabled in Mobile' WHERE nPackageTableUID = N'f60e5320-f1dc-4174-be20-cd8ce12741ba'
		UPDATE [dbo].[PackageTables] SET mNotes = N'This feature is not enabled in Mobile' WHERE nPackageTableUID = N'b795c35f-41f7-4d87-b124-f2b79f47768a'
		UPDATE [dbo].[PackageTables] SET mNotes = N'This feature is not enabled in Mobile' WHERE nPackageTableUID = N'1747df7d-7c9a-4915-abee-837d72c87f23'
		UPDATE [dbo].[PackageTables] SET mNotes = N'This feature is not enabled in Mobile' WHERE nPackageTableUID = N'c6f35204-55d7-457d-8102-1c434762bc92'
		UPDATE [dbo].[PackageTables] SET mNotes = N'This feature is not enabled in Mobile' WHERE nPackageTableUID = N'5b47949e-865c-4c04-92bf-7b2b87c6f50f'
		UPDATE [dbo].[PackageTables] SET mNotes = N'This feature is enabled in Mobile, but changes to settings should never be written back to the server' WHERE nPackageTableUID = N'b0f81d3f-cf7a-44b7-a111-39b26cc2da6b'
		UPDATE [dbo].[PackageTables] SET mNotes = N'Don''t touch during checkout' WHERE nPackageTableUID = N'f769ce60-432d-40ec-a001-28cdb096e565'
		UPDATE [dbo].[PackageTables] SET mNotes = N'Don''t touch during checkout' WHERE nPackageTableUID = N'7512ae1b-125b-411f-b736-0b8108ed55a6'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	BEGIN 
		PRINT N'Updating cTableName and mNotes for Package Table records'
		UPDATE [dbo].[PackageTables] SET cTableName = N'FacilityEx', mNotes = N'Table name MUST end with lowercase x!' WHERE nPackageTableUID = N'd584a497-7a58-4687-a2f4-90359967b9e8'
		UPDATE [dbo].[PackageTables] SET cTableName = N'FacilityEx', mNotes = N'Table name MUST end with lowercase x!' WHERE nPackageTableUID = N'f6fed11b-20f9-4c64-96de-ed115ba780d8'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '4a99df72-9956-4a08-b823-68f4cb5c3c42')
	BEGIN 
		PRINT N'Deleting Package Table record'
		DELETE FROM [dbo].[PackageTables] WHERE nPackageTableUID = N'4a99df72-9956-4a08-b823-68f4cb5c3c42'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	BEGIN 
		PRINT N'Updating nOrder for Package Table records'
		UPDATE [dbo].[PackageTables] SET nOrder = 20 WHERE nPackageTableUID = N'53b2f9b7-dcd9-4e6d-bbfa-9ef8beaa313d'
		UPDATE [dbo].[PackageTables] SET nOrder = 30 WHERE nPackageTableUID = N'cbb95a50-8d18-46da-8c34-880eb5e16fb2'
		UPDATE [dbo].[PackageTables] SET nOrder = 40 WHERE nPackageTableUID = N'd7aa572b-ae95-48c6-96d0-25b4ea1d8f6f'
		UPDATE [dbo].[PackageTables] SET nOrder = 50 WHERE nPackageTableUID = N'2d867660-4cdd-4d3b-9236-2b2142bc6a29'
		UPDATE [dbo].[PackageTables] SET nOrder = 60 WHERE nPackageTableUID = N'87e4d6e5-a93b-4b13-9f01-f08468f5486c'
		UPDATE [dbo].[PackageTables] SET nOrder = 70 WHERE nPackageTableUID = N'ea162f2d-5257-4c4f-ae90-392c3444481c'
		UPDATE [dbo].[PackageTables] SET nOrder = 80 WHERE nPackageTableUID = N'65f05dfc-3157-4844-be14-23708bbaf43a'
		UPDATE [dbo].[PackageTables] SET nOrder = 90 WHERE nPackageTableUID = N'77421811-312d-4c5b-a656-0ea81f6fe658'
		UPDATE [dbo].[PackageTables] SET nOrder = 100 WHERE nPackageTableUID = N'0e2a0148-8702-4e04-86db-0981e32ba31c'
		UPDATE [dbo].[PackageTables] SET nOrder = 110 WHERE nPackageTableUID = N'b0f81d3f-cf7a-44b7-a111-39b26cc2da6b'
		UPDATE [dbo].[PackageTables] SET nOrder = 120 WHERE nPackageTableUID = N'46c6b896-bca8-4645-b1bd-d95365f4872b'
		UPDATE [dbo].[PackageTables] SET nOrder = 130 WHERE nPackageTableUID = N'4aff2daa-3b72-40b3-8cbc-ba99cb011e26'
		UPDATE [dbo].[PackageTables] SET nOrder = 140 WHERE nPackageTableUID = N'2f3d6e49-7b35-459e-ad2b-f2dc4293b601'
		UPDATE [dbo].[PackageTables] SET nOrder = 150 WHERE nPackageTableUID = N'3d041c64-e358-4e86-901a-ce86319abfa1'
		UPDATE [dbo].[PackageTables] SET nOrder = 160 WHERE nPackageTableUID = N'9695ce6b-656a-4492-9283-ec614d2e64ad'
		UPDATE [dbo].[PackageTables] SET nOrder = 170 WHERE nPackageTableUID = N'3c5aa6ff-a837-4112-bb17-64d2e25b5fe3'
		UPDATE [dbo].[PackageTables] SET nOrder = 200 WHERE nPackageTableUID = N'8a05b5b6-4d6c-456e-b18e-7a65508fe229'
		UPDATE [dbo].[PackageTables] SET nOrder = 210 WHERE nPackageTableUID = N'c12e5442-2709-4a4b-ba6f-6254323751c2'
		UPDATE [dbo].[PackageTables] SET nOrder = 220 WHERE nPackageTableUID = N'fca84b7d-0faa-4ca8-8514-20005b2ceaea'
		UPDATE [dbo].[PackageTables] SET nOrder = 230 WHERE nPackageTableUID = N'334c1d4c-77e9-4612-b065-fb084a5def54'
		UPDATE [dbo].[PackageTables] SET nOrder = 240 WHERE nPackageTableUID = N'6cd7ebdb-cd6f-4995-855b-dd464b62b3b5'
		UPDATE [dbo].[PackageTables] SET nOrder = 250 WHERE nPackageTableUID = N'1e927f96-344e-4c45-a783-e4b6a6f5effd'
		UPDATE [dbo].[PackageTables] SET nOrder = 260 WHERE nPackageTableUID = N'7f456e02-87b5-44f7-a635-36d7a5d70a36'
		UPDATE [dbo].[PackageTables] SET nOrder = 270 WHERE nPackageTableUID = N'65fd6606-da6e-4942-9e22-eaf8a625a564'
		UPDATE [dbo].[PackageTables] SET nOrder = 280 WHERE nPackageTableUID = N'ff8633b7-d20c-4946-aa94-ef4221243652'
		UPDATE [dbo].[PackageTables] SET nOrder = 290 WHERE nPackageTableUID = N'70f53795-43bd-4d9f-98f7-4b094af24747'
		UPDATE [dbo].[PackageTables] SET nOrder = 300 WHERE nPackageTableUID = N'0a8a88b5-d87c-411b-afdb-331736a17a4c'
		UPDATE [dbo].[PackageTables] SET nOrder = 310 WHERE nPackageTableUID = N'a9007b22-7154-440f-9410-dc87220da9c5'
		UPDATE [dbo].[PackageTables] SET nOrder = 320 WHERE nPackageTableUID = N'afe5f69e-15ed-437e-9cd9-a185a4159e08'
		UPDATE [dbo].[PackageTables] SET nOrder = 330 WHERE nPackageTableUID = N'3d93c1a5-6648-4c76-8ade-1b10dd0731aa'
		UPDATE [dbo].[PackageTables] SET nOrder = 340 WHERE nPackageTableUID = N'092b5f19-a476-47e9-8473-0514c61cf396'
		UPDATE [dbo].[PackageTables] SET nOrder = 350 WHERE nPackageTableUID = N'cf2fb4b1-64ea-4d2a-83b0-a8cf36cc46ce'
		UPDATE [dbo].[PackageTables] SET nOrder = 360 WHERE nPackageTableUID = N'baf465df-1e9e-440b-8c49-5cd538b4e920'
		UPDATE [dbo].[PackageTables] SET nOrder = 370 WHERE nPackageTableUID = N'f60e5320-f1dc-4174-be20-cd8ce12741ba'
		UPDATE [dbo].[PackageTables] SET nOrder = 380 WHERE nPackageTableUID = N'b795c35f-41f7-4d87-b124-f2b79f47768a'
		UPDATE [dbo].[PackageTables] SET nOrder = 390 WHERE nPackageTableUID = N'1747df7d-7c9a-4915-abee-837d72c87f23'
		UPDATE [dbo].[PackageTables] SET nOrder = 400 WHERE nPackageTableUID = N'c6f35204-55d7-457d-8102-1c434762bc92'
		UPDATE [dbo].[PackageTables] SET nOrder = 410 WHERE nPackageTableUID = N'5b47949e-865c-4c04-92bf-7b2b87c6f50f'
		UPDATE [dbo].[PackageTables] SET nOrder = 420 WHERE nPackageTableUID = N'bee77ef8-0599-48a6-be71-043df9f1b3b5'
		UPDATE [dbo].[PackageTables] SET nOrder = 430 WHERE nPackageTableUID = N'd5c48b72-785a-4caa-a6ff-a66239d074be'
		UPDATE [dbo].[PackageTables] SET nOrder = 440 WHERE nPackageTableUID = N'7291d3fd-4690-40ce-88f6-75547e3f123e'
		UPDATE [dbo].[PackageTables] SET nOrder = 450 WHERE nPackageTableUID = N'54203db0-6ce7-4694-8a34-808547328e18'
		UPDATE [dbo].[PackageTables] SET nOrder = 460 WHERE nPackageTableUID = N'186f7f35-0c50-42bc-a826-105a8fe05db8'
		UPDATE [dbo].[PackageTables] SET nOrder = 470 WHERE nPackageTableUID = N'c0104380-b294-4c1b-ba4e-9895354c8a6b'
		UPDATE [dbo].[PackageTables] SET nOrder = 480 WHERE nPackageTableUID = N'e1aec21b-76c1-49bf-a0db-021f03715dcd'
		UPDATE [dbo].[PackageTables] SET nOrder = 490 WHERE nPackageTableUID = N'86dda0c4-661d-49ae-88bc-80c2fc365fb9'
		UPDATE [dbo].[PackageTables] SET nOrder = 500 WHERE nPackageTableUID = N'7deef36e-81f5-4339-8569-654196e2ce1e'
		UPDATE [dbo].[PackageTables] SET nOrder = 510 WHERE nPackageTableUID = N'b8b93596-5e7b-4ef2-bc3e-d1e3837830ba'
		UPDATE [dbo].[PackageTables] SET nOrder = 530 WHERE nPackageTableUID = N'b62323dc-9c48-457b-98d9-a38fbc922c75'
		UPDATE [dbo].[PackageTables] SET nOrder = 540 WHERE nPackageTableUID = N'c3d706b1-0e05-4c2f-8597-618bdf63e4f9'
		UPDATE [dbo].[PackageTables] SET nOrder = 550 WHERE nPackageTableUID = N'e9766aeb-b11d-4284-aad2-8dc8d417e4f0'
		UPDATE [dbo].[PackageTables] SET nOrder = 560 WHERE nPackageTableUID = N'8f5b682a-5c74-4346-85aa-246e829df777'
		UPDATE [dbo].[PackageTables] SET nOrder = 570 WHERE nPackageTableUID = N'95779119-2620-49c0-a036-1a4b6efd90fb'
		UPDATE [dbo].[PackageTables] SET nOrder = 580 WHERE nPackageTableUID = N'20bdf3b9-fc41-4e35-a961-70f8a36d7b61'
		UPDATE [dbo].[PackageTables] SET nOrder = 590 WHERE nPackageTableUID = N'a4907541-95e8-4974-8e55-17af4b56cb3d'
		UPDATE [dbo].[PackageTables] SET nOrder = 600 WHERE nPackageTableUID = N'f6fed11b-20f9-4c64-96de-ed115ba780d8'
		UPDATE [dbo].[PackageTables] SET nOrder = 610 WHERE nPackageTableUID = N'5ebe99aa-7e11-47ba-9595-5c83e0906a4e'
		UPDATE [dbo].[PackageTables] SET nOrder = 620 WHERE nPackageTableUID = N'1f81dafb-2453-4116-9234-af468939c086'
		UPDATE [dbo].[PackageTables] SET nOrder = 630 WHERE nPackageTableUID = N'aac0d42f-8045-456f-bc4c-819d9d94a1db'
		UPDATE [dbo].[PackageTables] SET nOrder = 640 WHERE nPackageTableUID = N'ed6eef92-07a5-4c43-b0d0-09ee0e340009'
		UPDATE [dbo].[PackageTables] SET nOrder = 650 WHERE nPackageTableUID = N'c8015e93-26e4-4e28-8869-f58ae7b7e7de'
		UPDATE [dbo].[PackageTables] SET nOrder = 660 WHERE nPackageTableUID = N'768863aa-ae16-433a-8e16-50881cdce864'
		UPDATE [dbo].[PackageTables] SET nOrder = 670 WHERE nPackageTableUID = N'0b67d614-56e8-4cd8-903b-c5e5caa1fdbf'
		UPDATE [dbo].[PackageTables] SET nOrder = 680 WHERE nPackageTableUID = N'f7a7f2f3-be69-42bc-8252-f2a2ff5c3580'
		UPDATE [dbo].[PackageTables] SET nOrder = 690 WHERE nPackageTableUID = N'2ebcae6f-23ce-4d0a-adc5-84c4b96038d7'
		UPDATE [dbo].[PackageTables] SET nOrder = 700 WHERE nPackageTableUID = N'54d7ac32-99eb-468f-824a-16e68b238a67'
		UPDATE [dbo].[PackageTables] SET nOrder = 710 WHERE nPackageTableUID = N'5a0965ac-3ec3-4dee-ab9c-fd01b588968c'
		UPDATE [dbo].[PackageTables] SET nOrder = 720 WHERE nPackageTableUID = N'55678e34-3f0d-470b-b65b-3fd4bd29ff02'
		UPDATE [dbo].[PackageTables] SET nOrder = 730 WHERE nPackageTableUID = N'cba09174-d159-4200-b0dd-6616a7e78964'
		UPDATE [dbo].[PackageTables] SET nOrder = 740 WHERE nPackageTableUID = N'0bdc22a4-f0d8-4e3b-9428-aa24eb330483'
		UPDATE [dbo].[PackageTables] SET nOrder = 750 WHERE nPackageTableUID = N'e913b816-2716-4aef-af6d-0917259419f3'
		UPDATE [dbo].[PackageTables] SET nOrder = 760 WHERE nPackageTableUID = N'b5a81d3e-2bfd-4460-93f4-d4b57c36e654'
		UPDATE [dbo].[PackageTables] SET nOrder = 770 WHERE nPackageTableUID = N'6d2cab02-30bb-4bef-9795-ff5ebd3db683'
		UPDATE [dbo].[PackageTables] SET nOrder = 780 WHERE nPackageTableUID = N'019e3730-a1d7-49ab-b62a-c4d523b35008'
		UPDATE [dbo].[PackageTables] SET nOrder = 790 WHERE nPackageTableUID = N'a9a3b7e1-8403-4df9-974a-52cfb16ae6c7'
		UPDATE [dbo].[PackageTables] SET nOrder = 800 WHERE nPackageTableUID = N'9f0778e2-6c78-4e27-9004-f5597b22ab3f'
		UPDATE [dbo].[PackageTables] SET nOrder = 810 WHERE nPackageTableUID = N'fb1591f3-5dc4-46cc-840a-9b9017a16822'
		UPDATE [dbo].[PackageTables] SET nOrder = 820 WHERE nPackageTableUID = N'9aa2b480-4e58-4308-8da1-7b8eab020d39'
		UPDATE [dbo].[PackageTables] SET nOrder = 830 WHERE nPackageTableUID = N'49507c1d-8482-46cd-8549-9b21cab6ef3b'
		UPDATE [dbo].[PackageTables] SET nOrder = 840 WHERE nPackageTableUID = N'edd38a72-6f44-4089-ac80-60f5190837c7'
		UPDATE [dbo].[PackageTables] SET nOrder = 850 WHERE nPackageTableUID = N'8bbb4408-2bc2-45cd-b559-e0e9cc587f65'
		UPDATE [dbo].[PackageTables] SET nOrder = 860 WHERE nPackageTableUID = N'327f6290-aa8a-43bb-90a7-9e5f936809d5'
		UPDATE [dbo].[PackageTables] SET nOrder = 870 WHERE nPackageTableUID = N'f68ce6d7-7ea7-42e5-a8f5-4f8f97ecfeb1'
		UPDATE [dbo].[PackageTables] SET nOrder = 880 WHERE nPackageTableUID = N'c5eace51-8a9c-4867-82de-d69c0a7e4dd6'
		UPDATE [dbo].[PackageTables] SET nOrder = 890 WHERE nPackageTableUID = N'f89a0c80-3a77-4ca9-a0f9-aefe33c31f04'
		UPDATE [dbo].[PackageTables] SET nOrder = 900 WHERE nPackageTableUID = N'f077e6b4-b3ef-4b5d-b795-26afc12cec49'
		UPDATE [dbo].[PackageTables] SET nOrder = 910 WHERE nPackageTableUID = N'41d589bf-94dd-477d-8ea1-762f6019ea71'
		UPDATE [dbo].[PackageTables] SET nOrder = 920 WHERE nPackageTableUID = N'42c97ead-cb8b-4778-8290-281d1cf31d1f'
		UPDATE [dbo].[PackageTables] SET nOrder = 940 WHERE nPackageTableUID = N'9c30a112-e9f2-4acf-bc72-de5069e89160'
		UPDATE [dbo].[PackageTables] SET nOrder = 950 WHERE nPackageTableUID = N'9cd5de8f-d698-4ecc-8636-d86c8ec5e7ff'
		UPDATE [dbo].[PackageTables] SET nOrder = 960 WHERE nPackageTableUID = N'5b000c71-bf06-48eb-a109-10853e85b371'
		UPDATE [dbo].[PackageTables] SET nOrder = 970 WHERE nPackageTableUID = N'2af4de77-efb2-4c71-a5f7-4ca1aac45681'
		UPDATE [dbo].[PackageTables] SET nOrder = 980 WHERE nPackageTableUID = N'5f29e6d1-969d-491c-b9c0-46347be012e1'
		UPDATE [dbo].[PackageTables] SET nOrder = 990 WHERE nPackageTableUID = N'143fc1bb-949f-4b91-bbb6-08290e996cb6'
		UPDATE [dbo].[PackageTables] SET nOrder = 1000 WHERE nPackageTableUID = N'343ffb3a-59c7-4ff7-8f6b-b5164b94ee85'
		UPDATE [dbo].[PackageTables] SET nOrder = 1010 WHERE nPackageTableUID = N'84e79adb-ba4a-48c8-9d85-44646a229503'
		UPDATE [dbo].[PackageTables] SET nOrder = 1020 WHERE nPackageTableUID = N'27382fa7-2b48-4077-8086-7a55db22b5a6'
		UPDATE [dbo].[PackageTables] SET nOrder = 1030 WHERE nPackageTableUID = N'bfd9485d-9d00-4f87-ab48-39b264823f10'
		UPDATE [dbo].[PackageTables] SET nOrder = 1040 WHERE nPackageTableUID = N'fdea87be-f679-48a1-92b6-41ae8af647fa'
		UPDATE [dbo].[PackageTables] SET nOrder = 1060 WHERE nPackageTableUID = N'605d5e12-da84-4613-a67d-7141f2b30222'
		UPDATE [dbo].[PackageTables] SET nOrder = 1070 WHERE nPackageTableUID = N'e104e46c-030d-4b2e-b854-d46e7909fbfb'
		UPDATE [dbo].[PackageTables] SET nOrder = 1080 WHERE nPackageTableUID = N'bb168824-0c9f-480e-820a-5bf195f21052'
		UPDATE [dbo].[PackageTables] SET nOrder = 1090 WHERE nPackageTableUID = N'ad5cfe78-3881-402a-ba0d-ac11e7c9ece2'
		UPDATE [dbo].[PackageTables] SET nOrder = 1100 WHERE nPackageTableUID = N'ddeee366-ae94-4684-a159-5930e74856b9'
		UPDATE [dbo].[PackageTables] SET nOrder = 1110 WHERE nPackageTableUID = N'5541108b-eae3-45f0-ab97-0eae8d262ef3'
		UPDATE [dbo].[PackageTables] SET nOrder = 1120 WHERE nPackageTableUID = N'dae7b8b8-2027-42a9-be1e-a7be7f78705b'
		UPDATE [dbo].[PackageTables] SET nOrder = 1130 WHERE nPackageTableUID = N'0d4aa866-1c69-41b7-bedc-fa1b952908e8'
		UPDATE [dbo].[PackageTables] SET nOrder = 1140 WHERE nPackageTableUID = N'78cc9f1a-d3d9-4940-bdfa-fbcd8fe4d427'
		UPDATE [dbo].[PackageTables] SET nOrder = 1150 WHERE nPackageTableUID = N'a3f88f66-bf10-40a7-8f41-5bdcfe1453fd'
		UPDATE [dbo].[PackageTables] SET nOrder = 1160 WHERE nPackageTableUID = N'a4c64c81-ddf9-4994-8ab0-42b130773dec'
		UPDATE [dbo].[PackageTables] SET nOrder = 1170 WHERE nPackageTableUID = N'0b375555-b3ce-4f90-8886-ed75a955db5f'
		UPDATE [dbo].[PackageTables] SET nOrder = 1180 WHERE nPackageTableUID = N'8cd0843c-7a49-404f-926e-ba001a9ac9e8'
		UPDATE [dbo].[PackageTables] SET nOrder = 1190 WHERE nPackageTableUID = N'e1d832ee-9dee-4b25-88a9-4b747e8e601a'
		UPDATE [dbo].[PackageTables] SET nOrder = 1200 WHERE nPackageTableUID = N'18b64d14-01b2-49ba-b31c-a95bee24bfc0'
		UPDATE [dbo].[PackageTables] SET nOrder = 1210 WHERE nPackageTableUID = N'2917ecfb-2586-48aa-891b-717045c79a7e'
		UPDATE [dbo].[PackageTables] SET nOrder = 1220 WHERE nPackageTableUID = N'49b3ba03-e2a4-4069-9710-138c48638e83'
		UPDATE [dbo].[PackageTables] SET nOrder = 1230 WHERE nPackageTableUID = N'63544dab-ac77-4e21-83d5-c80fca708c24'
		UPDATE [dbo].[PackageTables] SET nOrder = 1240 WHERE nPackageTableUID = N'1e5fbd9b-808e-4dac-92e3-b23dfa0c7fcb'
		UPDATE [dbo].[PackageTables] SET nOrder = 1250 WHERE nPackageTableUID = N'60cf4291-7a08-4820-864e-526bf230c10e'
		UPDATE [dbo].[PackageTables] SET nOrder = 1260 WHERE nPackageTableUID = N'3613c9c5-c1ee-4f67-b27f-4f25e4d033fc'
		UPDATE [dbo].[PackageTables] SET nOrder = 1270 WHERE nPackageTableUID = N'c88f5313-c20c-411c-a87e-25fdb77166dc'
		UPDATE [dbo].[PackageTables] SET nOrder = 1280 WHERE nPackageTableUID = N'2491d89c-c88f-40a9-83cf-21ef2309db80'
		UPDATE [dbo].[PackageTables] SET nOrder = 1290 WHERE nPackageTableUID = N'd6cb0768-9b7f-47a2-a4cf-adf2f719e01c'
		UPDATE [dbo].[PackageTables] SET nOrder = 1310 WHERE nPackageTableUID = N'0e76704e-e058-4f35-a6a9-cd6dc82a1ae4'
		UPDATE [dbo].[PackageTables] SET nOrder = 1320 WHERE nPackageTableUID = N'cc4ff8e3-0430-453b-a8b5-82f35fb217a7'
		UPDATE [dbo].[PackageTables] SET nOrder = 1330 WHERE nPackageTableUID = N'a8202ba7-d455-4cef-9b9d-2c8231b2eb7b'
		UPDATE [dbo].[PackageTables] SET nOrder = 1340 WHERE nPackageTableUID = N'a5bdeea5-f09f-4a70-89ce-ee2c47a68b1c'
		UPDATE [dbo].[PackageTables] SET nOrder = 1350 WHERE nPackageTableUID = N'c7a40f88-fe8c-437b-b44a-ea7550d030e2'
		UPDATE [dbo].[PackageTables] SET nOrder = 1360 WHERE nPackageTableUID = N'0907f389-af0f-462d-b40c-6f5655563f53'
		UPDATE [dbo].[PackageTables] SET nOrder = 1370 WHERE nPackageTableUID = N'666bc0fb-f3f2-4173-8247-2e78431b6b7f'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	BEGIN 
		PRINT N'Updating nOrder for Package Table records'
		UPDATE [dbo].[PackageTables] SET nOrder = 10 WHERE nPackageTableUID = N'04175741-b926-4424-82a3-512450b52a4f'
		UPDATE [dbo].[PackageTables] SET nOrder = 20 WHERE nPackageTableUID = N'c2ac2b08-2739-4c2b-a317-8c387a160683'
		UPDATE [dbo].[PackageTables] SET nOrder = 30 WHERE nPackageTableUID = N'152c6630-ae84-4e3d-9776-f9e8790c415b'
		UPDATE [dbo].[PackageTables] SET nOrder = 40 WHERE nPackageTableUID = N'ec814cf6-cb80-4b0a-bf8d-57774eb77f32'
		UPDATE [dbo].[PackageTables] SET nOrder = 50 WHERE nPackageTableUID = N'391b90ac-0ed0-4bcf-adc8-03232ca06bf0'
		UPDATE [dbo].[PackageTables] SET nOrder = 60 WHERE nPackageTableUID = N'bf7bfc19-d1c5-43ec-8813-4e12ed391c66'
		UPDATE [dbo].[PackageTables] SET nOrder = 70 WHERE nPackageTableUID = N'53363648-3462-4c51-9606-eb3436669ab4'
		UPDATE [dbo].[PackageTables] SET nOrder = 80 WHERE nPackageTableUID = N'2580359c-4c0f-4846-a1e8-80bb148b4117'
		UPDATE [dbo].[PackageTables] SET nOrder = 90 WHERE nPackageTableUID = N'7c66ead0-0744-4469-9bfd-9ab864daf88c'
		UPDATE [dbo].[PackageTables] SET nOrder = 100 WHERE nPackageTableUID = N'20b504b7-6073-49d1-a5f2-c3355d2f143c'
		UPDATE [dbo].[PackageTables] SET nOrder = 110 WHERE nPackageTableUID = N'9011bfc9-c1e3-4ad3-b945-6342eb13bb49'
		UPDATE [dbo].[PackageTables] SET nOrder = 120 WHERE nPackageTableUID = N'45d80f73-184d-4bfa-a019-bb95344ec028'
		UPDATE [dbo].[PackageTables] SET nOrder = 130 WHERE nPackageTableUID = N'23f6b28c-2ea7-4fdf-bd85-121c875c5f91'
		UPDATE [dbo].[PackageTables] SET nOrder = 140 WHERE nPackageTableUID = N'925fbf1c-05b1-410e-b58b-bec7a323b767'
		UPDATE [dbo].[PackageTables] SET nOrder = 150 WHERE nPackageTableUID = N'431f1151-edc7-4483-89de-7f6f65365379'
		UPDATE [dbo].[PackageTables] SET nOrder = 160 WHERE nPackageTableUID = N'0f5b6651-2f4d-457a-9b39-b2bea2e6c4d9'
		UPDATE [dbo].[PackageTables] SET nOrder = 170 WHERE nPackageTableUID = N'e0618e78-576a-4fdf-a796-436ede66abdd'
		UPDATE [dbo].[PackageTables] SET nOrder = 180 WHERE nPackageTableUID = N'45f67d4e-943f-454b-be27-357f5a32819e'
		UPDATE [dbo].[PackageTables] SET nOrder = 190 WHERE nPackageTableUID = N'afb0f349-48ff-44c4-b0fb-86a205c7fb2e'
		UPDATE [dbo].[PackageTables] SET nOrder = 200 WHERE nPackageTableUID = N'a56ad708-97f8-4632-8fe1-33dab4b82649'
		UPDATE [dbo].[PackageTables] SET nOrder = 210 WHERE nPackageTableUID = N'31334dd9-09dd-4ea7-b41f-0a915cfc67e8'
		UPDATE [dbo].[PackageTables] SET nOrder = 220 WHERE nPackageTableUID = N'959f7a04-aa2b-4a27-b4ce-79ccb442bc68'
		UPDATE [dbo].[PackageTables] SET nOrder = 230 WHERE nPackageTableUID = N'31dce2b0-77c9-4b78-829b-f8f8bc12990b'
		UPDATE [dbo].[PackageTables] SET nOrder = 240 WHERE nPackageTableUID = N'79ac2e36-57c1-4c5d-b7f2-64e4542e8a1e'
		UPDATE [dbo].[PackageTables] SET nOrder = 250 WHERE nPackageTableUID = N'e4c18790-0f79-45a4-8a8b-b916b282dd6b'
		UPDATE [dbo].[PackageTables] SET nOrder = 270 WHERE nPackageTableUID = N'd99f3ed1-6f83-45c1-b6d4-fb75cf576728'
		UPDATE [dbo].[PackageTables] SET nOrder = 280 WHERE nPackageTableUID = N'5d928552-d492-4819-83ea-e1db85c01f15'
		UPDATE [dbo].[PackageTables] SET nOrder = 290 WHERE nPackageTableUID = N'd584a497-7a58-4687-a2f4-90359967b9e8'
		UPDATE [dbo].[PackageTables] SET nOrder = 300 WHERE nPackageTableUID = N'2e8c967f-4d2b-4b05-bc63-3e6b8f2e6b62'
		UPDATE [dbo].[PackageTables] SET nOrder = 310 WHERE nPackageTableUID = N'23ddc148-4aa7-46ed-9642-d4c73c41d5cd'
		UPDATE [dbo].[PackageTables] SET nOrder = 320 WHERE nPackageTableUID = N'848d1201-2758-4ef2-ba3a-1339dba03c1a'
		UPDATE [dbo].[PackageTables] SET nOrder = 330 WHERE nPackageTableUID = N'cdd90665-b529-4f1c-b88a-6ddede3d1795'
		UPDATE [dbo].[PackageTables] SET nOrder = 340 WHERE nPackageTableUID = N'f769ce60-432d-40ec-a001-28cdb096e565'
		UPDATE [dbo].[PackageTables] SET nOrder = 370 WHERE nPackageTableUID = N'7512ae1b-125b-411f-b736-0b8108ed55a6'
		UPDATE [dbo].[PackageTables] SET nOrder = 380 WHERE nPackageTableUID = N'de463740-8b53-4a97-b6b9-d8d87cf40677'
		UPDATE [dbo].[PackageTables] SET nOrder = 390 WHERE nPackageTableUID = N'e0d88dca-2dbd-4ab8-95e6-12a1836139e9'
		UPDATE [dbo].[PackageTables] SET nOrder = 400 WHERE nPackageTableUID = N'2e73d47c-97d0-4514-94b4-2fcfd967540f'
		UPDATE [dbo].[PackageTables] SET nOrder = 410 WHERE nPackageTableUID = N'06cf92cf-e59b-4e9e-aabf-804bed93fa20'
		UPDATE [dbo].[PackageTables] SET nOrder = 420 WHERE nPackageTableUID = N'022f87be-5ec3-4a46-96b3-878e15e2fb72'
		UPDATE [dbo].[PackageTables] SET nOrder = 430 WHERE nPackageTableUID = N'5fa40313-d915-4cc7-ab3e-19fbdf2f7196'
		UPDATE [dbo].[PackageTables] SET nOrder = 440 WHERE nPackageTableUID = N'f24be771-90be-42cf-8f1b-ba97715fd53d'
		UPDATE [dbo].[PackageTables] SET nOrder = 450 WHERE nPackageTableUID = N'18a9be8a-407d-462c-bf7c-5c1e3a4c6c3c'
		UPDATE [dbo].[PackageTables] SET nOrder = 460 WHERE nPackageTableUID = N'ea7040db-af8a-4354-bff9-55326f6b2fe0'
		UPDATE [dbo].[PackageTables] SET nOrder = 470 WHERE nPackageTableUID = N'a87dfb58-d2c3-4596-b459-1f2f3b3a0edd'
		UPDATE [dbo].[PackageTables] SET nOrder = 480 WHERE nPackageTableUID = N'd69d3ffc-d173-4424-bf1b-23987cf1d0a2'
		UPDATE [dbo].[PackageTables] SET nOrder = 490 WHERE nPackageTableUID = N'530cf35c-96f3-4177-8f2c-c73aced90f90'
		UPDATE [dbo].[PackageTables] SET nOrder = 500 WHERE nPackageTableUID = N'ec3f506d-eb9e-4126-98e5-6d80aee0091a'
		UPDATE [dbo].[PackageTables] SET nOrder = 510 WHERE nPackageTableUID = N'0cd42818-fa28-4737-9f8b-2fea68e7a362'
		UPDATE [dbo].[PackageTables] SET nOrder = 520 WHERE nPackageTableUID = N'53976f85-0ec9-4c82-8807-43b198db3dbc'
		UPDATE [dbo].[PackageTables] SET nOrder = 530 WHERE nPackageTableUID = N'1f843872-cb90-4167-a76a-d3cf18270193'
		UPDATE [dbo].[PackageTables] SET nOrder = 540 WHERE nPackageTableUID = N'090769b1-495d-48bb-ad83-8379b7f4d942'
		UPDATE [dbo].[PackageTables] SET nOrder = 550 WHERE nPackageTableUID = N'12b093ba-1846-419c-9937-c9e21218a79b'
		UPDATE [dbo].[PackageTables] SET nOrder = 560 WHERE nPackageTableUID = N'1bb594c5-d8c3-48ac-bc9d-5dcc993c060f'
		UPDATE [dbo].[PackageTables] SET nOrder = 570 WHERE nPackageTableUID = N'3ef24537-479c-4e74-a3dd-9ca4d9d40699'
		UPDATE [dbo].[PackageTables] SET nOrder = 580 WHERE nPackageTableUID = N'18f61877-80cf-41ab-8a37-ca3dae7a7b3d'
		UPDATE [dbo].[PackageTables] SET nOrder = 590 WHERE nPackageTableUID = N'384cc9dc-12bc-4905-8ef6-c64884b56fc8'
		UPDATE [dbo].[PackageTables] SET nOrder = 600 WHERE nPackageTableUID = N'e584ff24-957a-43ca-8703-bd4a6fdcbada'
		UPDATE [dbo].[PackageTables] SET nOrder = 610 WHERE nPackageTableUID = N'b1e0fe6e-2884-478d-8e8f-d3ddc68d29de'
		UPDATE [dbo].[PackageTables] SET nOrder = 620 WHERE nPackageTableUID = N'03829195-c34a-47c6-9532-969e83790c06'
		UPDATE [dbo].[PackageTables] SET nOrder = 630 WHERE nPackageTableUID = N'37ce493b-681b-4a0d-9f97-f537bc6391f2'
		UPDATE [dbo].[PackageTables] SET nOrder = 640 WHERE nPackageTableUID = N'ed28d8b8-d2a9-43ec-b823-6e33cfd04c51'
		UPDATE [dbo].[PackageTables] SET nOrder = 650 WHERE nPackageTableUID = N'04a7ec2a-900f-478e-8349-df783056b111'
		UPDATE [dbo].[PackageTables] SET nOrder = 660 WHERE nPackageTableUID = N'c8434d44-cb80-4b15-8f8b-6335b6396146'
		UPDATE [dbo].[PackageTables] SET nOrder = 670 WHERE nPackageTableUID = N'5821c62e-6d16-4c88-a597-c839f37f1b53'
		UPDATE [dbo].[PackageTables] SET nOrder = 680 WHERE nPackageTableUID = N'dd59763c-840d-40b8-b3f6-836c6f198b8e'
		UPDATE [dbo].[PackageTables] SET nOrder = 690 WHERE nPackageTableUID = N'1af7b1f1-1499-4b59-96c4-e39a1d66171e'
		UPDATE [dbo].[PackageTables] SET nOrder = 700 WHERE nPackageTableUID = N'86a0ffcd-7426-487c-b033-1a1f634633c0'
		UPDATE [dbo].[PackageTables] SET nOrder = 710 WHERE nPackageTableUID = N'3436d717-22a0-4b38-8db0-b4bc46f77607'
		UPDATE [dbo].[PackageTables] SET nOrder = 720 WHERE nPackageTableUID = N'3157bd69-15e3-415e-b67a-070b5c93d9b2'
		UPDATE [dbo].[PackageTables] SET nOrder = 730 WHERE nPackageTableUID = N'916741f1-7771-4b84-b1bf-5e5735cd0803'
		UPDATE [dbo].[PackageTables] SET nOrder = 740 WHERE nPackageTableUID = N'45a96ec8-2e76-495c-9adf-3f8475d72f87'
		UPDATE [dbo].[PackageTables] SET nOrder = 750 WHERE nPackageTableUID = N'51cf7441-64da-48f5-85bf-6d9f1ef86c9f'
		UPDATE [dbo].[PackageTables] SET nOrder = 770 WHERE nPackageTableUID = N'9c44d629-6794-42ed-bfef-00cf06cb67dd'
		UPDATE [dbo].[PackageTables] SET nOrder = 780 WHERE nPackageTableUID = N'6150904c-88b6-4c87-92e7-e4b0da31ff91'
		UPDATE [dbo].[PackageTables] SET nOrder = 790 WHERE nPackageTableUID = N'56b0fcb1-0740-41dc-aed1-a09c0d03422d'
		UPDATE [dbo].[PackageTables] SET nOrder = 800 WHERE nPackageTableUID = N'40d28354-c27a-4f0c-8a19-0293b6d27907'
		UPDATE [dbo].[PackageTables] SET nOrder = 810 WHERE nPackageTableUID = N'693deec1-1e49-4c78-8700-68ab766efcc8'
		UPDATE [dbo].[PackageTables] SET nOrder = 820 WHERE nPackageTableUID = N'3d1d8d07-a737-4e0a-b6b2-342c79ad5262'
		UPDATE [dbo].[PackageTables] SET nOrder = 830 WHERE nPackageTableUID = N'9455dc08-b064-41de-8eaa-5358d8300fb7'
		UPDATE [dbo].[PackageTables] SET nOrder = 840 WHERE nPackageTableUID = N'd5bbb65b-865c-485f-976b-97feb154f72e'
		UPDATE [dbo].[PackageTables] SET nOrder = 850 WHERE nPackageTableUID = N'7218c01f-c47b-4aea-a076-b113b0c83e3a'
		UPDATE [dbo].[PackageTables] SET nOrder = 860 WHERE nPackageTableUID = N'dbe9857a-9901-4cc5-8705-088537b32cf9'
		UPDATE [dbo].[PackageTables] SET nOrder = 870 WHERE nPackageTableUID = N'27bc127f-b962-46d2-bd5a-09b52afe3282'
		UPDATE [dbo].[PackageTables] SET nOrder = 880 WHERE nPackageTableUID = N'dbaf2f9a-a5c9-411c-987c-c96b4c01f832'
		UPDATE [dbo].[PackageTables] SET nOrder = 890 WHERE nPackageTableUID = N'f1ccfcdb-50af-4aba-b32a-d970871488a1'
		UPDATE [dbo].[PackageTables] SET nOrder = 900 WHERE nPackageTableUID = N'bd8aa470-e570-47e3-b2a0-b9d267fa7bec'
		UPDATE [dbo].[PackageTables] SET nOrder = 910 WHERE nPackageTableUID = N'd20b5fa9-ff49-443a-912f-c6b59ce5ab24'
		UPDATE [dbo].[PackageTables] SET nOrder = 920 WHERE nPackageTableUID = N'853c72eb-e19d-4c09-b2af-2ad73e18cd0f'
		UPDATE [dbo].[PackageTables] SET nOrder = 930 WHERE nPackageTableUID = N'50785385-5a63-4b32-843d-edaec15f1700'
		UPDATE [dbo].[PackageTables] SET nOrder = 940 WHERE nPackageTableUID = N'09c3ca89-12a4-4b6f-90ee-cad9813ec2ab'
		UPDATE [dbo].[PackageTables] SET nOrder = 950 WHERE nPackageTableUID = N'a6772051-0866-406a-86d4-613fdb10ab86'
		UPDATE [dbo].[PackageTables] SET nOrder = 970 WHERE nPackageTableUID = N'4816e58f-6c06-421f-937e-a170bc73bebd'
		UPDATE [dbo].[PackageTables] SET nOrder = 980 WHERE nPackageTableUID = N'b8105aee-6ab5-4746-ae47-7e4180252c18'
		UPDATE [dbo].[PackageTables] SET nOrder = 1000 WHERE nPackageTableUID = N'a354be4b-6835-44e2-ba6c-db134e11fec6'
		UPDATE [dbo].[PackageTables] SET nOrder = 1010 WHERE nPackageTableUID = N'632496f4-a9f0-4b8b-9d11-b2797b75cbf5'
		UPDATE [dbo].[PackageTables] SET nOrder = 1020 WHERE nPackageTableUID = N'a9b4b2c2-ac8e-45cb-9f14-17b85ac1ecfa'
		UPDATE [dbo].[PackageTables] SET nOrder = 1030 WHERE nPackageTableUID = N'97c2a5e1-5e3a-47f7-891d-b20e42169489'
		UPDATE [dbo].[PackageTables] SET nOrder = 1040 WHERE nPackageTableUID = N'8939326e-ad53-4877-ae9d-bec983457520'
		UPDATE [dbo].[PackageTables] SET nOrder = 1050 WHERE nPackageTableUID = N'301d70eb-743b-4e8b-9adf-e71a6a1f03fd'
		UPDATE [dbo].[PackageTables] SET nOrder = 1060 WHERE nPackageTableUID = N'23586600-f605-483e-81eb-2356373f5419'
		UPDATE [dbo].[PackageTables] SET nOrder = 1070 WHERE nPackageTableUID = N'56fe8a0a-a24e-4ae0-bc8e-4e1a8a17f9b1'
		UPDATE [dbo].[PackageTables] SET nOrder = 1080 WHERE nPackageTableUID = N'65be4402-992d-4eb7-9815-7963a08ca52d'
		UPDATE [dbo].[PackageTables] SET nOrder = 1090 WHERE nPackageTableUID = N'3a42cfc0-bcba-4c03-b018-292d661d5a42'
		UPDATE [dbo].[PackageTables] SET nOrder = 1100 WHERE nPackageTableUID = N'b5fb6c2c-c1e1-4fd8-9ce2-a52389682f0a'
		UPDATE [dbo].[PackageTables] SET nOrder = 1110 WHERE nPackageTableUID = N'7df9d967-34e5-463d-be25-40ac666e14c7'
		UPDATE [dbo].[PackageTables] SET nOrder = 1120 WHERE nPackageTableUID = N'aebfcb11-005e-4836-9b5c-afc271f9ed76'
		UPDATE [dbo].[PackageTables] SET nOrder = 1130 WHERE nPackageTableUID = N'645f51c6-a0f5-42c7-a156-8ea9eee134da'
		UPDATE [dbo].[PackageTables] SET nOrder = 1140 WHERE nPackageTableUID = N'ab682f80-dac1-4eae-9c23-bc8bda91b52a'
		UPDATE [dbo].[PackageTables] SET nOrder = 1150 WHERE nPackageTableUID = N'f52cc376-4afa-44d9-9198-0c70317aba83'
		UPDATE [dbo].[PackageTables] SET nOrder = 1160 WHERE nPackageTableUID = N'63c03487-76eb-4826-a008-be6eb9a7036f'
		UPDATE [dbo].[PackageTables] SET nOrder = 1170 WHERE nPackageTableUID = N'0a209a77-f9eb-4227-9749-619501014ee6'
		UPDATE [dbo].[PackageTables] SET nOrder = 1180 WHERE nPackageTableUID = N'51225569-2ff3-4068-b255-97cfedbaa855'
		UPDATE [dbo].[PackageTables] SET nOrder = 1190 WHERE nPackageTableUID = N'5d2bcb14-7eff-4ff1-afaa-943eb5a3cad0'
		UPDATE [dbo].[PackageTables] SET nOrder = 1200 WHERE nPackageTableUID = N'd9b9c19c-b784-4117-bd7e-c6cc7ed03e21'
		UPDATE [dbo].[PackageTables] SET nOrder = 1210 WHERE nPackageTableUID = N'7a7c743a-76e5-41b1-9fa9-f8a16ed9d0bd'
		UPDATE [dbo].[PackageTables] SET nOrder = 1220 WHERE nPackageTableUID = N'46957e48-528d-49eb-82dd-984d6d18faf4'
		UPDATE [dbo].[PackageTables] SET nOrder = 1230 WHERE nPackageTableUID = N'3cc3d256-12aa-4f4e-b0ef-0e7dcc3d3faa'
		UPDATE [dbo].[PackageTables] SET nOrder = 1240 WHERE nPackageTableUID = N'b1515c58-6d1a-48b9-a3e5-89da91e2ad56'
		UPDATE [dbo].[PackageTables] SET nOrder = 1250 WHERE nPackageTableUID = N'86d43d9b-978c-45cb-8bd4-53079235b5d4'
		UPDATE [dbo].[PackageTables] SET nOrder = 1260 WHERE nPackageTableUID = N'7fcde98c-5c9f-4167-99c8-c86e60b8dcfe'
		UPDATE [dbo].[PackageTables] SET nOrder = 1270 WHERE nPackageTableUID = N'4fc77674-26fe-422c-b588-8cf99402136e'
		UPDATE [dbo].[PackageTables] SET nOrder = 1280 WHERE nPackageTableUID = N'56151d4f-d099-4e0a-939f-a76477bba41e'
		UPDATE [dbo].[PackageTables] SET nOrder = 1290 WHERE nPackageTableUID = N'25467b37-9d73-4e4f-9ec6-e62ac2b2cb4d'
		UPDATE [dbo].[PackageTables] SET nOrder = 1300 WHERE nPackageTableUID = N'b6a02cb8-f683-43e1-8dd5-5bfef4a61afd'
		UPDATE [dbo].[PackageTables] SET nOrder = 1310 WHERE nPackageTableUID = N'2355a66c-d3f2-4726-bd0b-724e277d7814'
		UPDATE [dbo].[PackageTables] SET nOrder = 1320 WHERE nPackageTableUID = N'126c06ce-2031-493c-afc7-01af7bac0c60'
		UPDATE [dbo].[PackageTables] SET nOrder = 1330 WHERE nPackageTableUID = N'826866f7-4b7c-4ac5-bb20-666c94203dd2'
		UPDATE [dbo].[PackageTables] SET nOrder = 1340 WHERE nPackageTableUID = N'5d6c6006-5e34-4111-aca7-869310faa56c'
		UPDATE [dbo].[PackageTables] SET nOrder = 1350 WHERE nPackageTableUID = N'a188fb16-0080-404f-a734-550f3a8ef56c'
		UPDATE [dbo].[PackageTables] SET nOrder = 1360 WHERE nPackageTableUID = N'44411408-a94f-43ad-a5c0-020bc0a0e479'
		UPDATE [dbo].[PackageTables] SET nOrder = 1370 WHERE nPackageTableUID = N'6f3d13dd-1498-4e6f-9cd6-e3c46d1705ee'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '2a9f0e18-ddb6-4cde-876e-c022f98ab03a')
	BEGIN 
		PRINT N'Adding Package Table record for AvailableConfigTableColumns'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'2a9f0e18-ddb6-4cde-876e-c022f98ab03a', 3, N'AvailableConfigTableColumns', NULL, N'_System', 260, 0, 0, 0, N'Don''t touch during checkout', 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '466576f1-0541-42cd-aff5-2b372c400b4a')
	BEGIN 
		PRINT N'Adding Package Table record for AuditLookups'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'466576f1-0541-42cd-aff5-2b372c400b4a', 3, N'AuditLookups', NULL, N'_System', 350, 0, 0, 0, N'Don''t touch during checkout', 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '508f3983-0c35-4b1e-8991-88bf19490fc0')
	BEGIN 
		PRINT N'Adding Package Table record for AuditRelationships'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'508f3983-0c35-4b1e-8991-88bf19490fc0', 3, N'AuditRelationships', NULL, N'_System', 360, 0, 0, 0, N'Don''t touch during checkout', 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '758112c6-da88-44b7-b39e-31d1fa5f7711')
	BEGIN 
		PRINT N'Adding Package Table record for ManualTemplateRowTolerances'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'758112c6-da88-44b7-b39e-31d1fa5f7711', 3, N'ManualTemplateRowTolerances', NULL, N'_System', 760, 0, 0, 1, N'Don''t touch during checkout', 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'f8b81f4a-e4f6-49dd-8ed3-67ca3f60831f')
	BEGIN 
		PRINT N'Adding Package Table record for AssetFiles'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'f8b81f4a-e4f6-49dd-8ed3-67ca3f60831f', 3, N'AssetFiles', NULL, N'_System', 960, 1, 1, 1, N'Truncate entire table', -1, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '8820b862-43d2-4e0e-9af5-a96144686a41')
	BEGIN 
		PRINT N'Adding Package Table record for CallSheetResultStandardLink'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'8820b862-43d2-4e0e-9af5-a96144686a41', 3, N'CallSheetResultStandardLink', NULL, N'_System', 990, 1, 1, 1, N'Truncate entire table', 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '1ceea0c3-af4a-4e70-bdae-7df6c0c3e63b')
	BEGIN 
		PRINT N'Adding Package Table record for ConfiguredInstrumentsWip'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'1ceea0c3-af4a-4e70-bdae-7df6c0c3e63b', 3, N'ConfiguredInstrumentsWip', NULL, N'_System', 1380, 1, 1, 1, N'Truncate entire table', -1, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'b0a2a0f2-66d7-4450-8c0e-1bbf565662d5')
	BEGIN 
		PRINT N'Adding Package Table record for ConfiguredInstrumentsWip'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'b0a2a0f2-66d7-4450-8c0e-1bbf565662d5', 4, N'ConfiguredInstrumentsWip', NULL, N'_System', 10, 0, 0, 0, N'Temporary table', 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'd79673b6-658b-416b-ada1-f496bafa8217')
	BEGIN 
		PRINT N'Adding Package Table record for AuditRelationships'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'd79673b6-658b-416b-ada1-f496bafa8217', 4, N'AuditRelationships', NULL, N'_System', 180, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'ad0d57bb-ba2e-49ba-9403-4a75099f4e87')
	BEGIN 
		PRINT N'Adding Package Table record for AuditLookups'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'ad0d57bb-ba2e-49ba-9403-4a75099f4e87', 4, N'AuditLookups', NULL, N'_System', 190, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '14630320-dfa6-4bba-ad81-1e9496b763a7')
	BEGIN 
		PRINT N'Adding Package Table record for ManualTemplateRowTolerances'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'14630320-dfa6-4bba-ad81-1e9496b763a7', 4, N'ManualTemplateRowTolerances', NULL, N'_System', 520, 0, 0, 0, NULL, -1, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
		
	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '245b045f-b266-4883-bafc-8870078f9f56')
	BEGIN 
		PRINT N'Adding Package Table record for AssetFiles'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'245b045f-b266-4883-bafc-8870078f9f56', 4, N'AssetFiles', NULL, N'_System', 930, 0, 0, 0, NULL, -1, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '051af77e-a9a5-44ba-9980-c2f9e5710afa')
	BEGIN 
		PRINT N'Adding Package Table record for CallSheetResultStandardLink'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'051af77e-a9a5-44ba-9980-c2f9e5710afa', 4, N'CallSheetResultStandardLink', NULL, N'_System', 1050, 0, 0, 0, NULL, -1, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'e7412cc4-3cf1-4754-b9c2-05ea29ac5f77')
	BEGIN 
		PRINT N'Adding Package Table record for AvailableConfigTableColumns'
		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes, lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'e7412cc4-3cf1-4754-b9c2-05ea29ac5f77', 4, N'AvailableConfigTableColumns', NULL, N'_System', 1300, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220324 00:00:00.000', N'20220324 00:00:00.000',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 


	-->>MTM-6028<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE [nPackageTableUID] = '6F3D13DD-1498-4E6F-9CD6-E3C46D1705EE' )
	BEGIN
		PRINT 'Adding PackageTables entry: 6F3D13DD-1498-4E6F-9CD6-E3C46D1705EE'

		INSERT INTO [dbo].[PackageTables] ([nPackageTableUID],[nTransferType] ,[cTableName],[cCustomWhere],[cAuthority],[nOrder],[nAddAction],[nUpdateAction],[nDeleteAction],[mNotes],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES ('6F3D13DD-1498-4E6F-9CD6-E3C46D1705EE',3,'TypePartsLink',NULL,'_System',1370,0,0,0,NULL,0,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220201 02:21:52','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220201 02:21:52','20220201 02:21:52',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE [nPackageTableUID] = '666BC0FB-F3F2-4173-8247-2E78431B6B7F' )
	BEGIN
		PRINT 'Adding PackageTables entry: 666BC0FB-F3F2-4173-8247-2E78431B6B7F'

		INSERT INTO [dbo].[PackageTables] ([nPackageTableUID],[nTransferType] ,[cTableName],[cCustomWhere],[cAuthority],[nOrder],[nAddAction],[nUpdateAction],[nDeleteAction],[mNotes],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES ('666BC0FB-F3F2-4173-8247-2E78431B6B7F',4,'TypePartsLink',NULL,'_System',1370,0,0,0,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220201 02:21:52','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220201 02:21:52','20220201 02:21:52',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-5283<<--
	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_ProceduresWithEx' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_ProceduresWithEx]'

		DROP VIEW [dbo].[vw_ProceduresWithEx]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
		
	IF OBJECT_ID(N'[dbo].[vw_ProceduresWithEx]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_ProceduresWithEx]'

		EXEC sp_executesql N'
/*****************************************************************************************************************
	vw_ProceduresWithEx

	(C) 2022 Fluke Calibration
------------------------------------------------------------------------------------------------------------------
	CHANGE HISTORY
	03/28/2022  MM  Initial Version
*****************************************************************************************************************/
CREATE VIEW [dbo].[vw_ProceduresWithEx]
AS
SELECT
	pro.[nProcedureUID],
	pro.[nCategoryUID],
	pro.[cProcedureName],
	pro.[cProcedureNumber],
	pro.[cAuthority],
	pro.[cProcedureType],
	pro.[cVersion],
	pro.[cRevision],
	pro.[tProcedureDate],
	pro.[tRevisionDate],
	pro.[mNotes],
	CAST (pro.[mNotes] AS NTEXT) AS [mNotesText],
	pro.[lLocked],
	pro.[lActive],
	pro.[lDeleted],
	pro.[lApproved],
	pro.[lAdded],
	pro.[nAddFacilityUID],
	pro.[nAddUserUID],
	pro.[tAddTime],
	pro.[nUpdateFacilityUID],
	pro.[nUpdateUserUID],
	pro.[tUpdateTime],
	cat.cDescription AS [cCategory],
	file1.cFileName AS [DataSheet],
	file2.cFileName AS [ProcedureFile],
	ex.[cField1],
	ex.[cField2],
	ex.[cField3],
	ex.[cField4],
	ex.[cField5],
	ex.[cField6],
	ex.[cField7],
	ex.[cField8],
	ex.[cField9],
	ex.[cField10],
	ex.[tField1],
	ex.[tField2],
	ex.[tField3],
	ex.[tField4],
	ex.[tField5],
	ex.[nField1],
	ex.[nField2],
	ex.[nField3],
	ex.[nField4],
	ex.[nField5],
	ex.[nField6],
	ex.[nField7],
	ex.[nField8],
	ex.[nField9],
	ex.[nField10],
	COALESCE(ex.[lField1], 0) AS [lField1],
	COALESCE(ex.[lField2], 0) AS [lField2],
	COALESCE(ex.[lField3], 0) AS [lField3],
	COALESCE(ex.[lField4], 0) AS [lField4],
	COALESCE(ex.[lField5], 0) AS [lField5],
	COALESCE(ex.[lField6], 0) AS [lField6],
	COALESCE(ex.[lField7], 0) AS [lField7],
	COALESCE(ex.[lField8], 0) AS [lField8],
	COALESCE(ex.[lField9], 0) AS [lField9],
	COALESCE(ex.[lField10], 0) AS [lField10],
	ex.[mField1],
	CAST (ex.[mField1] AS NTEXT) AS [mField1Text],
	ex.[mField2],
	CAST (ex.[mField2] AS NTEXT) AS [mField2Text],
	COALESCE(ex.[lActive], 0) AS [lExActive],
	COALESCE(ex.[lDeleted], 0) AS [lExDeleted]
FROM
	[dbo].[Procedures] pro
LEFT OUTER JOIN
	[dbo].[ProcedureEx] ex ON pro.[nProcedureUID] = ex.[nProcedureUID]
LEFT OUTER JOIN
	[dbo].[Category] cat ON pro.[nCategoryUID] = cat.[nCategoryUID]
LEFT OUTER JOIN
	[dbo].[Files] file1 ON pro.[nAttTemplateUID] = file1.[nFileUID]	
LEFT OUTER JOIN
	[dbo].[Files] file2 ON pro.[nProcedureFileUID] = file2.[nFileUID]	
WHERE
	pro.[lDeleted] = 0
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4a96c0d9-6206-487e-9581-1f9241c6a37b')
	BEGIN 
	    PRINT N'Adding Context Element for DataSheet'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('4a96c0d9-6206-487e-9581-1f9241c6a37b','F897DA63-4CBA-470C-92A5-50783869BA52',N'Field',N'DataSheet',N'Data Sheet',300,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 


	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '304e1c21-3a25-4deb-8d93-a9775d509133')
	BEGIN 
	    PRINT N'Adding Context Element Link for DataSheet'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('304e1c21-3a25-4deb-8d93-a9775d509133','FCC69069-493A-4B2A-8E0F-2346F7AC319A','4a96c0d9-6206-487e-9581-1f9241c6a37b',N'AND',11,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'be97be08-f52a-4876-8d89-76256affd9e7')
	BEGIN 
	    PRINT N'Adding Context Element for ProcedureFile'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('be97be08-f52a-4876-8d89-76256affd9e7','f1bd5d98-5b25-47de-a7e6-52bed7df377d',N'Field',N'ProcedureFile',N'Procedure File',300,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f97a0cae-4326-432b-b30e-62ed6ddd7dd5')
	BEGIN 
	    PRINT N'Adding Context Element Link for ProcedureFile'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f97a0cae-4326-432b-b30e-62ed6ddd7dd5','FCC69069-493A-4B2A-8E0F-2346F7AC319A','be97be08-f52a-4876-8d89-76256affd9e7',N'AND',12,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4881b8d4-2b7d-4a33-b853-43d9a245695b')
	BEGIN 
	    PRINT N'Adding Context Element for cField1'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('4881b8d4-2b7d-4a33-b853-43d9a245695b',NULL,N'Field',N'cField1',N'ProcedureEx.cField1',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0f415281-bef7-4d14-adc9-218665173389')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField1'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0f415281-bef7-4d14-adc9-218665173389','FCC69069-493A-4B2A-8E0F-2346F7AC319A','4881b8d4-2b7d-4a33-b853-43d9a245695b',N'AND',13,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 	 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c7ecff12-21f0-4da0-a47c-baf4c7ca3c09')
	BEGIN 
	    PRINT N'Adding Context Element for cField2'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c7ecff12-21f0-4da0-a47c-baf4c7ca3c09',NULL,N'Field',N'cField2',N'ProcedureEx.cField2',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '043b0ab2-47f9-431c-a0b0-436679652e65')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField2'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('043b0ab2-47f9-431c-a0b0-436679652e65','FCC69069-493A-4B2A-8E0F-2346F7AC319A','c7ecff12-21f0-4da0-a47c-baf4c7ca3c09',N'AND',14,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ba87aa92-978c-4319-8f20-f2d2976d8223')
	BEGIN 
	    PRINT N'Adding Context Element for cField3'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ba87aa92-978c-4319-8f20-f2d2976d8223',NULL,N'Field',N'cField3',N'ProcedureEx.cField3',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'c6721d0b-8503-4823-9a5c-a8c95403d14c')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField3'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('c6721d0b-8503-4823-9a5c-a8c95403d14c','FCC69069-493A-4B2A-8E0F-2346F7AC319A','ba87aa92-978c-4319-8f20-f2d2976d8223',N'AND',15,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '190ee5ac-4641-4553-a6eb-97e34dc34a67')
	BEGIN 
	    PRINT N'Adding Context Element for cField4'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('190ee5ac-4641-4553-a6eb-97e34dc34a67',NULL,N'Field',N'cField4',N'ProcedureEx.cField4',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2ba9107a-0ca4-47c5-94b5-68a03d95659f')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField4'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('2ba9107a-0ca4-47c5-94b5-68a03d95659f','FCC69069-493A-4B2A-8E0F-2346F7AC319A','190ee5ac-4641-4553-a6eb-97e34dc34a67',N'AND',16,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c0ff4891-8644-4172-ad4d-4e3b38956980')
	BEGIN 
	    PRINT N'Adding Context Element for cField5'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c0ff4891-8644-4172-ad4d-4e3b38956980',NULL,N'Field',N'cField5',N'ProcedureEx.cField5',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'cfe453d0-df8b-4b42-adce-b8ba7ecf0d7b')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField5'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('cfe453d0-df8b-4b42-adce-b8ba7ecf0d7b','FCC69069-493A-4B2A-8E0F-2346F7AC319A','c0ff4891-8644-4172-ad4d-4e3b38956980',N'AND',17,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8abf2811-8fe7-46e7-a184-f25aff696449')
	BEGIN 
	    PRINT N'Adding Context Element for cField6'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8abf2811-8fe7-46e7-a184-f25aff696449',NULL,N'Field',N'cField6',N'ProcedureEx.cField6',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '79ee19da-0f02-4e81-bb2e-44c4b20f3c82')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField6'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('79ee19da-0f02-4e81-bb2e-44c4b20f3c82','FCC69069-493A-4B2A-8E0F-2346F7AC319A','8abf2811-8fe7-46e7-a184-f25aff696449',N'AND',18,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7e0c8787-31e0-4d7f-b735-620c8ea1a914')
	BEGIN 
	    PRINT N'Adding Context Element for cField7'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('7e0c8787-31e0-4d7f-b735-620c8ea1a914',NULL,N'Field',N'cField7',N'ProcedureEx.cField7',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'b0a264be-c241-461d-8c78-e6bbe558f716')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField7'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('b0a264be-c241-461d-8c78-e6bbe558f716','FCC69069-493A-4B2A-8E0F-2346F7AC319A','7e0c8787-31e0-4d7f-b735-620c8ea1a914',N'AND',19,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '2a5dd6e1-82ca-46ea-8ba6-0c6c88cd0e98')
	BEGIN 
	    PRINT N'Adding Context Element for cField8'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('2a5dd6e1-82ca-46ea-8ba6-0c6c88cd0e98',NULL,N'Field',N'cField8',N'ProcedureEx.cField8',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'dbbe04fb-91d6-4921-930c-92a0846bfeee')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField8'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('dbbe04fb-91d6-4921-930c-92a0846bfeee','FCC69069-493A-4B2A-8E0F-2346F7AC319A','2a5dd6e1-82ca-46ea-8ba6-0c6c88cd0e98',N'AND',20,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '60271d4a-6bc9-4812-8dc5-ecbf977155a9')
	BEGIN 
	    PRINT N'Adding Context Element for cField9'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('60271d4a-6bc9-4812-8dc5-ecbf977155a9',NULL,N'Field',N'cField9',N'ProcedureEx.cField9',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '30cfb0e1-7e43-41c5-a355-d2e6b83002d4')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField9'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('30cfb0e1-7e43-41c5-a355-d2e6b83002d4','FCC69069-493A-4B2A-8E0F-2346F7AC319A','60271d4a-6bc9-4812-8dc5-ecbf977155a9',N'AND',21,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'f56cc72b-0acf-4ffd-8afb-6717508bf081')
	BEGIN 
	    PRINT N'Adding Context Element for cField10'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('f56cc72b-0acf-4ffd-8afb-6717508bf081',NULL,N'Field',N'cField10',N'ProcedureEx.cField10',66,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0e3b59f5-8214-4034-b0dc-57e6675b0531')
	BEGIN 
	    PRINT N'Adding Context Element Link for cField10'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0e3b59f5-8214-4034-b0dc-57e6675b0531','FCC69069-493A-4B2A-8E0F-2346F7AC319A','f56cc72b-0acf-4ffd-8afb-6717508bf081',N'AND',22,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6aca4128-376f-487f-9063-ebef995d5b73')
	BEGIN 
	    PRINT N'Adding Context Element for tField1'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('6aca4128-376f-487f-9063-ebef995d5b73',NULL,N'Field',N'tField1',N'ProcedureEx.tField1',66,NULL,NULL,NULL,8,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6657e742-607b-4d06-9f67-8db41d3be132')
	BEGIN 
	    PRINT N'Adding Context Element Link for tField1'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('6657e742-607b-4d06-9f67-8db41d3be132','FCC69069-493A-4B2A-8E0F-2346F7AC319A','6aca4128-376f-487f-9063-ebef995d5b73',N'AND',23,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 	

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '40e77420-c053-4022-9845-cc146e3a5d95')
	BEGIN 
	    PRINT N'Adding Context Element for tField2'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('40e77420-c053-4022-9845-cc146e3a5d95',NULL,N'Field',N'tField2',N'ProcedureEx.tField2',66,NULL,NULL,NULL,8,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'fb544c40-a4fd-4356-a147-edf765f6819c')
	BEGIN 
	    PRINT N'Adding Context Element Link for tField2'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('fb544c40-a4fd-4356-a147-edf765f6819c','FCC69069-493A-4B2A-8E0F-2346F7AC319A','40e77420-c053-4022-9845-cc146e3a5d95',N'AND',24,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '632e983d-c418-4370-a24d-d9f70aed31f9')
	BEGIN 
	    PRINT N'Adding Context Element for tField3'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('632e983d-c418-4370-a24d-d9f70aed31f9',NULL,N'Field',N'tField3',N'ProcedureEx.tField3',66,NULL,NULL,NULL,8,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '9ecb7818-4168-4067-90a0-9313c4f683fd')
	BEGIN 
	    PRINT N'Adding Context Element Link for tField3'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('9ecb7818-4168-4067-90a0-9313c4f683fd','FCC69069-493A-4B2A-8E0F-2346F7AC319A','632e983d-c418-4370-a24d-d9f70aed31f9',N'AND',25,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a406e489-a790-4804-a9a7-d7f0cf7c47de')
	BEGIN 
	    PRINT N'Adding Context Element for tField4'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a406e489-a790-4804-a9a7-d7f0cf7c47de',NULL,N'Field',N'tField4',N'ProcedureEx.tField4',66,NULL,NULL,NULL,8,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'e4acac4e-10ed-4928-890b-3fc3cfa1219e')
	BEGIN 
	    PRINT N'Adding Context Element Link for tField4'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e4acac4e-10ed-4928-890b-3fc3cfa1219e','FCC69069-493A-4B2A-8E0F-2346F7AC319A','a406e489-a790-4804-a9a7-d7f0cf7c47de',N'AND',26,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '9d07becc-66d2-40b8-8b20-546ae0eb2359')
	BEGIN 
	    PRINT N'Adding Context Element for tField5'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('9d07becc-66d2-40b8-8b20-546ae0eb2359',NULL,N'Field',N'tField5',N'ProcedureEx.tField5',66,NULL,NULL,NULL,8,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5d5a16e3-07fc-483e-a2dc-01833a4cb7a5')
	BEGIN 
	    PRINT N'Adding Context Element Link for tField5'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5d5a16e3-07fc-483e-a2dc-01833a4cb7a5','FCC69069-493A-4B2A-8E0F-2346F7AC319A','9d07becc-66d2-40b8-8b20-546ae0eb2359',N'AND',27,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ac07b4ec-1f3c-4387-85a2-b5f673042b00')
	BEGIN 
	    PRINT N'Adding Context Element for nField1'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ac07b4ec-1f3c-4387-85a2-b5f673042b00',NULL,N'Field',N'nField1',N'ProcedureEx.nField1',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '421fed15-c752-4081-8896-9cd2954f0a9e')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField1'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('421fed15-c752-4081-8896-9cd2954f0a9e','FCC69069-493A-4B2A-8E0F-2346F7AC319A','ac07b4ec-1f3c-4387-85a2-b5f673042b00',N'AND',28,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 	

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '362798fb-f98b-4438-989d-cba4fdc989b1')
	BEGIN 
	    PRINT N'Adding Context Element for nField2'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('362798fb-f98b-4438-989d-cba4fdc989b1',NULL,N'Field',N'nField2',N'ProcedureEx.nField2',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '83bbbd57-9a4d-4a35-a518-37d7ae97ec5c')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField2'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('83bbbd57-9a4d-4a35-a518-37d7ae97ec5c','FCC69069-493A-4B2A-8E0F-2346F7AC319A','362798fb-f98b-4438-989d-cba4fdc989b1',N'AND',29,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '42e66b9e-362c-4497-ba75-a2a84a8ffd1e')
	BEGIN 
	    PRINT N'Adding Context Element for nField3'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('42e66b9e-362c-4497-ba75-a2a84a8ffd1e',NULL,N'Field',N'nField3',N'ProcedureEx.nField3',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1ad01f77-a2be-4aa9-a785-90e7ce449d59')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField3'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1ad01f77-a2be-4aa9-a785-90e7ce449d59','FCC69069-493A-4B2A-8E0F-2346F7AC319A','42e66b9e-362c-4497-ba75-a2a84a8ffd1e',N'AND',30,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '2bb24244-ca52-461b-bc6f-2b53ad0be556')
	BEGIN 
	    PRINT N'Adding Context Element for nField4'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('2bb24244-ca52-461b-bc6f-2b53ad0be556',NULL,N'Field',N'nField4',N'ProcedureEx.nField4',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6538c037-785b-4ce4-ab0e-6775cc9bc9fe')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField4'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('6538c037-785b-4ce4-ab0e-6775cc9bc9fe','FCC69069-493A-4B2A-8E0F-2346F7AC319A','2bb24244-ca52-461b-bc6f-2b53ad0be556',N'AND',31,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 	

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '76c6962a-7478-4967-abd2-dd604c7b7f51')
	BEGIN 
	    PRINT N'Adding Context Element for nField5'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('76c6962a-7478-4967-abd2-dd604c7b7f51',NULL,N'Field',N'nField5',N'ProcedureEx.nField5',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1caf4c62-30a3-4518-ab7a-b08ad36da0e8')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField5'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1caf4c62-30a3-4518-ab7a-b08ad36da0e8','FCC69069-493A-4B2A-8E0F-2346F7AC319A','76c6962a-7478-4967-abd2-dd604c7b7f51',N'AND',32,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '139ab38c-5b51-45e7-9a4f-003946d403d5')
	BEGIN 
	    PRINT N'Adding Context Element for nField6'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('139ab38c-5b51-45e7-9a4f-003946d403d5',NULL,N'Field',N'nField6',N'ProcedureEx.nField6',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f128b414-4297-46d2-ad46-f1280c10b8ca')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField6'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f128b414-4297-46d2-ad46-f1280c10b8ca','FCC69069-493A-4B2A-8E0F-2346F7AC319A','139ab38c-5b51-45e7-9a4f-003946d403d5',N'AND',33,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c9428d3d-a007-4161-a645-626fc7258ac6')
	BEGIN 
	    PRINT N'Adding Context Element for nField7'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c9428d3d-a007-4161-a645-626fc7258ac6',NULL,N'Field',N'nField7',N'ProcedureEx.nField7',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4627e287-c8ea-43a6-9f53-41c1a2bdc59c')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField7'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('4627e287-c8ea-43a6-9f53-41c1a2bdc59c','FCC69069-493A-4B2A-8E0F-2346F7AC319A','c9428d3d-a007-4161-a645-626fc7258ac6',N'AND',34,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '276e65e6-d576-4ef0-be58-848cd6d737c4')
	BEGIN 
	    PRINT N'Adding Context Element for nField8'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('276e65e6-d576-4ef0-be58-848cd6d737c4',NULL,N'Field',N'nField8',N'ProcedureEx.nField8',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '98d69606-2492-4b41-af63-2640ac603667')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField8'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('98d69606-2492-4b41-af63-2640ac603667','FCC69069-493A-4B2A-8E0F-2346F7AC319A','276e65e6-d576-4ef0-be58-848cd6d737c4',N'AND',35,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ade060e9-6441-473a-b927-e71ffad0fade')
	BEGIN 
	    PRINT N'Adding Context Element for nField9'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ade060e9-6441-473a-b927-e71ffad0fade',NULL,N'Field',N'nField9',N'ProcedureEx.nField9',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2f1a5c69-6ff6-4994-9fa4-7731941de95f')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField9'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('2f1a5c69-6ff6-4994-9fa4-7731941de95f','FCC69069-493A-4B2A-8E0F-2346F7AC319A','ade060e9-6441-473a-b927-e71ffad0fade',N'AND',36,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '5c1ad6b6-a7a1-4b29-8a25-f4721660fce7')
	BEGIN 
	    PRINT N'Adding Context Element for nField10'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('5c1ad6b6-a7a1-4b29-8a25-f4721660fce7',NULL,N'Field',N'nField10',N'ProcedureEx.nField10',66,NULL,NULL,NULL,2,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4984a602-f584-41c8-8e34-2e418178900c')
	BEGIN 
	    PRINT N'Adding Context Element Link for nField10'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('4984a602-f584-41c8-8e34-2e418178900c','FCC69069-493A-4B2A-8E0F-2346F7AC319A','5c1ad6b6-a7a1-4b29-8a25-f4721660fce7',N'AND',37,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8b6d8030-2ac6-4352-9c4e-a0a96eddaa7f')
	BEGIN 
	    PRINT N'Adding Context Element for lField1'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8b6d8030-2ac6-4352-9c4e-a0a96eddaa7f',NULL,N'Field',N'lField1',N'ProcedureEx.lField1',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0fcad6be-fa63-4edb-9812-c9f83f939001')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField1'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0fcad6be-fa63-4edb-9812-c9f83f939001','FCC69069-493A-4B2A-8E0F-2346F7AC319A','8b6d8030-2ac6-4352-9c4e-a0a96eddaa7f',N'AND',38,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c1394180-eb55-4e13-af8d-6b222fb04123')
	BEGIN 
	    PRINT N'Adding Context Element for lField2'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c1394180-eb55-4e13-af8d-6b222fb04123',NULL,N'Field',N'lField2',N'ProcedureEx.lField2',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '29a1d206-dfbf-43f9-9a93-ccdbf45e6baf')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField2'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('29a1d206-dfbf-43f9-9a93-ccdbf45e6baf','FCC69069-493A-4B2A-8E0F-2346F7AC319A','c1394180-eb55-4e13-af8d-6b222fb04123',N'AND',39,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '180db228-1c7d-43c1-8656-80315d6d76ba')
	BEGIN 
	    PRINT N'Adding Context Element for lField3'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('180db228-1c7d-43c1-8656-80315d6d76ba',NULL,N'Field',N'lField3',N'ProcedureEx.lField3',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'a6b2274b-d436-407e-835e-e1fce6ad9a02')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField3'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a6b2274b-d436-407e-835e-e1fce6ad9a02','FCC69069-493A-4B2A-8E0F-2346F7AC319A','180db228-1c7d-43c1-8656-80315d6d76ba',N'AND',40,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '12deba68-275c-4e7d-ba30-49a7efb751c8')
	BEGIN 
	    PRINT N'Adding Context Element for lField4'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('12deba68-275c-4e7d-ba30-49a7efb751c8',NULL,N'Field',N'lField4',N'ProcedureEx.lField4',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0d0b775a-401b-48bd-8046-f7579a3546ab')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField4'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0d0b775a-401b-48bd-8046-f7579a3546ab','FCC69069-493A-4B2A-8E0F-2346F7AC319A','12deba68-275c-4e7d-ba30-49a7efb751c8',N'AND',41,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '9869e3e0-6f07-433f-a76a-fdeb04a1260a')
	BEGIN 
	    PRINT N'Adding Context Element for lField5'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('9869e3e0-6f07-433f-a76a-fdeb04a1260a',NULL,N'Field',N'lField5',N'ProcedureEx.lField5',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1e94f00a-eb21-4384-84f8-17a6334d8448')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField5'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1e94f00a-eb21-4384-84f8-17a6334d8448','FCC69069-493A-4B2A-8E0F-2346F7AC319A','9869e3e0-6f07-433f-a76a-fdeb04a1260a',N'AND',42,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '721a5459-e1e0-4138-ae46-d69c94faa0ec')
	BEGIN 
	    PRINT N'Adding Context Element for lField6'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('721a5459-e1e0-4138-ae46-d69c94faa0ec',NULL,N'Field',N'lField6',N'ProcedureEx.lField6',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'd128054d-d3da-4e76-a79c-f1d2ef8d9e72')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField6'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('d128054d-d3da-4e76-a79c-f1d2ef8d9e72','FCC69069-493A-4B2A-8E0F-2346F7AC319A','721a5459-e1e0-4138-ae46-d69c94faa0ec',N'AND',43,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '52f3da8d-c874-4fc4-a0ec-2262549d2ebe')
	BEGIN 
	    PRINT N'Adding Context Element for lField7'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('52f3da8d-c874-4fc4-a0ec-2262549d2ebe',NULL,N'Field',N'lField7',N'ProcedureEx.lField7',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4652b094-3900-4044-821e-352d9f325f77')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField7'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('4652b094-3900-4044-821e-352d9f325f77','FCC69069-493A-4B2A-8E0F-2346F7AC319A','52f3da8d-c874-4fc4-a0ec-2262549d2ebe',N'AND',44,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '872679e3-77b6-41f8-bde8-9c631ba7e229')
	BEGIN 
	    PRINT N'Adding Context Element for lField8'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('872679e3-77b6-41f8-bde8-9c631ba7e229',NULL,N'Field',N'lField8',N'ProcedureEx.lField8',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '157c9090-fca4-4c69-9cb4-875a5b1d857e')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField8'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('157c9090-fca4-4c69-9cb4-875a5b1d857e','FCC69069-493A-4B2A-8E0F-2346F7AC319A','872679e3-77b6-41f8-bde8-9c631ba7e229',N'AND',45,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4f1e68df-2e4d-4aa3-a823-f88257eca487')
	BEGIN 
	    PRINT N'Adding Context Element for lField9'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('4f1e68df-2e4d-4aa3-a823-f88257eca487',NULL,N'Field',N'lField9',N'ProcedureEx.lField9',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '91003f6b-d7ab-4b97-8c79-49bcf19f2dd3')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField9'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('91003f6b-d7ab-4b97-8c79-49bcf19f2dd3','FCC69069-493A-4B2A-8E0F-2346F7AC319A','4f1e68df-2e4d-4aa3-a823-f88257eca487',N'AND',46,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8ae582ed-8f92-497c-bbc1-5cb72142b822')
	BEGIN 
	    PRINT N'Adding Context Element for lField10'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8ae582ed-8f92-497c-bbc1-5cb72142b822',NULL,N'Field',N'lField10',N'ProcedureEx.lField10',66,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4b174e82-dcd8-4cf1-9dcc-21e1d8042360')
	BEGIN 
	    PRINT N'Adding Context Element Link for lField10'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('4b174e82-dcd8-4cf1-9dcc-21e1d8042360','FCC69069-493A-4B2A-8E0F-2346F7AC319A','8ae582ed-8f92-497c-bbc1-5cb72142b822',N'AND',47,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7410dd7c-86e0-4af4-8e49-b1f4adeef129')
	BEGIN 
	    PRINT N'Adding Context Element for mField1'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('7410dd7c-86e0-4af4-8e49-b1f4adeef129',NULL,N'Field',N'mField1',N'ProcedureEx.mField1',300,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f8f412f1-9c7c-4244-bd3c-06ac997c423e')
	BEGIN 
	    PRINT N'Adding Context Element Link for mField1'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f8f412f1-9c7c-4244-bd3c-06ac997c423e','FCC69069-493A-4B2A-8E0F-2346F7AC319A','7410dd7c-86e0-4af4-8e49-b1f4adeef129',N'AND',48,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '09068be8-aa36-46a7-b328-a1041f3ddb8a')
	BEGIN 
	    PRINT N'Adding Context Element for mField2'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('09068be8-aa36-46a7-b328-a1041f3ddb8a',NULL,N'Field',N'mField2',N'ProcedureEx.mField2',300,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6ff0d638-4d39-4c2f-98c1-4fd34f087ac3')
	BEGIN 
	    PRINT N'Adding Context Element Link for mField2'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('6ff0d638-4d39-4c2f-98c1-4fd34f087ac3','FCC69069-493A-4B2A-8E0F-2346F7AC319A','09068be8-aa36-46a7-b328-a1041f3ddb8a',N'AND',49,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220329 17:10:32.000','20220329 17:10:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6A3CDF72-9CCA-4125-8089-6EE2FC8B1594')
	BEGIN
		IF (SELECT cValue FROM [dbo].[ContextElements] WHERE nContextElementUID = '6A3CDF72-9CCA-4125-8089-6EE2FC8B1594') <> 'SELECT strFields, pro.nProcedureUID AS [UID] FROM vw_ProceduresWithEx pro strWhere strOrder'
		BEGIN
			PRINT N'Updating Context Element'

			UPDATE 
				[dbo].[ContextElements] 
			SET 
				[cValue] = 'SELECT strFields, pro.nProcedureUID AS [UID] FROM vw_ProceduresWithEx pro strWhere strOrder',
				[tUpdateTime] = '20220329 17:10:32.000',
				[tMobileTime] = '20220329 17:10:32.000'
			WHERE nContextElementUID = '6A3CDF72-9CCA-4125-8089-6EE2FC8B1594'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'AD0C0D5C-1BC4-49DE-816B-5A3B73C366B1')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'AD0C0D5C-1BC4-49DE-816B-5A3B73C366B1' AND nStyle = 1)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 1,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = 'AD0C0D5C-1BC4-49DE-816B-5A3B73C366B1'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '345B0255-8ADF-474B-84FC-DEBCD779204D')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '345B0255-8ADF-474B-84FC-DEBCD779204D' AND nStyle = 1)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 1,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = '345B0255-8ADF-474B-84FC-DEBCD779204D'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END
	
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'BEF7EB5B-3B25-4023-83D4-4ABF852C55EB')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'BEF7EB5B-3B25-4023-83D4-4ABF852C55EB' AND nStyle = 1)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 1,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = 'BEF7EB5B-3B25-4023-83D4-4ABF852C55EB'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END
	
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F64901F8-5279-42A9-8DB4-ADAB1D1C137A')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F64901F8-5279-42A9-8DB4-ADAB1D1C137A' AND nStyle = 1)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 1,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = 'F64901F8-5279-42A9-8DB4-ADAB1D1C137A'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END
		
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'CB54BEA7-BBFA-4D1E-B9F6-F904247A0B45')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'CB54BEA7-BBFA-4D1E-B9F6-F904247A0B45' AND nStyle = 1)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 1,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = 'CB54BEA7-BBFA-4D1E-B9F6-F904247A0B45'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END
		
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4E8C08F5-BE6D-4925-A6DB-34D416F8A03C')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4E8C08F5-BE6D-4925-A6DB-34D416F8A03C' AND nStyle = 1)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 1,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = '4E8C08F5-BE6D-4925-A6DB-34D416F8A03C'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END
		
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7FD8F836-8D3B-46FA-B043-0208ECAC2F1E')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7FD8F836-8D3B-46FA-B043-0208ECAC2F1E' AND nStyle = 8)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 8,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = '7FD8F836-8D3B-46FA-B043-0208ECAC2F1E'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END
		
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '05BB9023-407E-4E7F-8003-1CBE85C74B54')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '05BB9023-407E-4E7F-8003-1CBE85C74B54' AND nStyle = 1)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 1,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = '05BB9023-407E-4E7F-8003-1CBE85C74B54'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END
		
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '726F23C2-5A43-42CC-9559-E6C0291E740D')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '726F23C2-5A43-42CC-9559-E6C0291E740D' AND nStyle = 8)
		BEGIN
				PRINT N'Updating Context Element'

				UPDATE
					[dbo].[ContextElements]
				SET
					[nStyle] = 8,
					[tUpdateTime] = '20220329 17:10:32.000',
					[tMobileTime] = '20220329 17:10:32.000'
				WHERE
					nContextElementUID = '726F23C2-5A43-42CC-9559-E6C0291E740D'

			    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END


	-->>MTM-7639<<--
	IF OBJECT_ID(N'[dbo].[PromptTypes]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[PromptTypes]'

		CREATE TABLE [dbo].[PromptTypes](
			[nPromptTypeUID] [uniqueidentifier] ROWGUIDCOL NOT NULL,
			[cPromptTypeDisplay] [nvarchar](20) NOT NULL,
			[nPromptValue] [int] NULL,
			[lActive] [int] NOT NULL,
			[lDeleted] [int] NOT NULL,
			[lApproved] [int] NOT NULL,
			[lAdded] [int] NOT NULL,
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
		 CONSTRAINT [PK_PromptTypes] PRIMARY KEY NONCLUSTERED
		(
			[nPromptTypeUID] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
		) ON [PRIMARY]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_lActive]  DEFAULT (-1) FOR [lActive]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_lDeleted]  DEFAULT (0) FOR [lDeleted]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_lApproved]  DEFAULT (0) FOR [lApproved]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_lAdded]  DEFAULT (-1) FOR [lAdded]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_nAddFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nAddFacilityUID]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_nAddUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nAddUserUID]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_tAddTime]  DEFAULT (GETUTCDATE()) FOR [tAddTime]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_nUpdateFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nUpdateFacilityUID]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_nUpdateUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nUpdateUserUID]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_tUpdateTime]  DEFAULT (GETUTCDATE()) FOR [tUpdateTime]

		ALTER TABLE [dbo].[PromptTypes] ADD  CONSTRAINT [DF_PromptTypes_tMobileTime]  DEFAULT (GETUTCDATE()) FOR [tMobileTime]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique system identifier used by the system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'nPromptTypeUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User selection Pass / Fail or Pre Prompt' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'cPromptTypeDisplay'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=Fail; -1 or 1=Pass; NULL=Pre' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'nPromptValue'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=inactive; -1 or 1=active' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'lActive'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not deleted; -1 or 1=deleted' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'lDeleted'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not approved; -1 or 1=approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'lApproved'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not added; -1 or 1=added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'lAdded'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'nAddFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the user that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'nAddUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'tAddTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that last updated the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'nUpdateFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the last user to update the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'nUpdateUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'tUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for Mobile mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'tMobileTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for the Warehouse' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'tSystemUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If imported, contains UID of the import record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes', @level2type=N'COLUMN',@level2name=N'nImportUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Defines the types of prompts supported by MET/CAL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTypes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[Prompts]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[Prompts]'

		CREATE TABLE [dbo].[Prompts](
			[nPromptUID] [uniqueidentifier] ROWGUIDCOL NOT NULL,
			[nPromptTypeUID] [uniqueidentifier] NOT NULL,
			[cPromptName] [nvarchar](150) NOT NULL,
			[mNotes] [nvarchar](max) NULL,
			[lActive] [int] NOT NULL,
			[lDeleted] [int] NOT NULL,
			[lApproved] [int] NOT NULL,
			[lAdded] [int] NOT NULL,
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
		 CONSTRAINT [PK_Prompts] PRIMARY KEY NONCLUSTERED
		(
			[nPromptUID] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
		) ON [PRIMARY]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_lActive]  DEFAULT (-1) FOR [lActive]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_lDeleted]  DEFAULT (0) FOR [lDeleted]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_lApproved]  DEFAULT (0) FOR [lApproved]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_lAdded]  DEFAULT (-1) FOR [lAdded]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_nAddFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nAddFacilityUID]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_nAddUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nAddUserUID]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_tAddTime]  DEFAULT (GETUTCDATE()) FOR [tAddTime]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_nUpdateFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nUpdateFacilityUID]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_nUpdateUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nUpdateUserUID]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_tUpdateTime]  DEFAULT (GETUTCDATE()) FOR [tUpdateTime]

		ALTER TABLE [dbo].[Prompts] ADD  CONSTRAINT [DF_Prompts_tMobileTime]  DEFAULT (GETUTCDATE()) FOR [tMobileTime]

		ALTER TABLE [dbo].[Prompts]  WITH CHECK ADD  CONSTRAINT [FK_Prompts_PromptTypes]  FOREIGN KEY ([nPromptTypeUID]) REFERENCES [dbo].[PromptTypes] ([nPromptTypeUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique system identifier used by the system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'nPromptUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to PromptTypes' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'nPromptTypeUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Prompt name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'cPromptName'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=inactive; -1 or 1=active' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'lActive'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not deleted; -1 or 1=deleted' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'lDeleted'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not approved; -1 or 1=approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'lApproved'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not added; -1 or 1=added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'lAdded'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'nAddFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the user that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'nAddUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'tAddTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that last updated the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'nUpdateFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the last user to update the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'nUpdateUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'tUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for Mobile mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'tMobileTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for the Warehouse' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'tSystemUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If imported, contains UID of the import record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts', @level2type=N'COLUMN',@level2name=N'nImportUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains prompt configurations for MET/CAL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Prompts'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[PromptTables]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[PromptTables]'

		CREATE TABLE [dbo].[PromptTables](
			[nPromptTableUID] [uniqueidentifier] ROWGUIDCOL NOT NULL,
			[cTableName] [nvarchar](128) NOT NULL,
			[lActive] [int] NOT NULL,
			[lDeleted] [int] NOT NULL,
			[lApproved] [int] NOT NULL,
			[lAdded] [int] NOT NULL,
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
		 CONSTRAINT [PK_PromptTables] PRIMARY KEY NONCLUSTERED
		(
			[nPromptTableUID] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
		) ON [PRIMARY]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_lActive]  DEFAULT (-1) FOR [lActive]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_lDeleted]  DEFAULT (0) FOR [lDeleted]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_lApproved]  DEFAULT (0) FOR [lApproved]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_lAdded]  DEFAULT (-1) FOR [lAdded]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_nAddFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nAddFacilityUID]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_nAddUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nAddUserUID]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_tAddTime]  DEFAULT (GETUTCDATE()) FOR [tAddTime]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_nUpdateFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nUpdateFacilityUID]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_nUpdateUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nUpdateUserUID]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_tUpdateTime]  DEFAULT (GETUTCDATE()) FOR [tUpdateTime]

		ALTER TABLE [dbo].[PromptTables] ADD  CONSTRAINT [DF_PromptTables_tMobileTime]  DEFAULT (GETUTCDATE()) FOR [tMobileTime]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique system identifier used by the system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'nPromptTableUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'cTableName'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=inactive; -1 or 1=active' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'lActive'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not deleted; -1 or 1=deleted' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'lDeleted'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not approved; -1 or 1=approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'lApproved'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not added; -1 or 1=added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'lAdded'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'nAddFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the user that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'nAddUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'tAddTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that last updated the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'nUpdateFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the last user to update the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'nUpdateUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'tUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for Mobile mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'tMobileTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for the Warehouse' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'tSystemUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If imported, contains UID of the import record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables', @level2type=N'COLUMN',@level2name=N'nImportUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains tables supported by MET/CAL prompts' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptTables'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[PromptColumns]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[PromptColumns]'

		CREATE TABLE [dbo].[PromptColumns](
			[nPromptColumnUID] [uniqueidentifier] ROWGUIDCOL NOT NULL,
			[nPromptTableUID] [uniqueidentifier] NOT NULL,
			[cColumnName] [nvarchar](128) NOT NULL,
			[lActive] [int] NOT NULL,
			[lDeleted] [int] NOT NULL,
			[lApproved] [int] NOT NULL,
			[lAdded] [int] NOT NULL,
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
		 CONSTRAINT [PK_PromptColumns] PRIMARY KEY NONCLUSTERED
		(
			[nPromptColumnUID] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
		) ON [PRIMARY]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_lActive]  DEFAULT (-1) FOR [lActive]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_lDeleted]  DEFAULT (0) FOR [lDeleted]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_lApproved]  DEFAULT (0) FOR [lApproved]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_lAdded]  DEFAULT (-1) FOR [lAdded]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_nAddFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nAddFacilityUID]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_nAddUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nAddUserUID]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_tAddTime]  DEFAULT (GETUTCDATE()) FOR [tAddTime]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_nUpdateFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nUpdateFacilityUID]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_nUpdateUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nUpdateUserUID]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_tUpdateTime]  DEFAULT (GETUTCDATE()) FOR [tUpdateTime]

		ALTER TABLE [dbo].[PromptColumns] ADD  CONSTRAINT [DF_PromptColumns_tMobileTime]  DEFAULT (GETUTCDATE()) FOR [tMobileTime]

		ALTER TABLE [dbo].[PromptColumns]  WITH CHECK ADD  CONSTRAINT [FK_PromptColumns_PromptTables]  FOREIGN KEY ([nPromptTableUID]) REFERENCES [dbo].[PromptTables] ([nPromptTableUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique system identifier used by the system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'nPromptColumnUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to PromptTables' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'nPromptTableUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Column name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'cColumnName'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=inactive; -1 or 1=active' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'lActive'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not deleted; -1 or 1=deleted' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'lDeleted'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not approved; -1 or 1=approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'lApproved'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not added; -1 or 1=added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'lAdded'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'nAddFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the user that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'nAddUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'tAddTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that last updated the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'nUpdateFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the last user to update the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'nUpdateUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'tUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for Mobile mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'tMobileTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for the Warehouse' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'tSystemUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If imported, contains UID of the import record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns', @level2type=N'COLUMN',@level2name=N'nImportUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains supported columns for tables supported by MET/CAL prompts' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptColumns'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[PromptFields]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[PromptFields]'

		CREATE TABLE [dbo].[PromptFields](
			[nPromptFieldUID] [uniqueidentifier] ROWGUIDCOL NOT NULL,
			[nPromptUID] [uniqueidentifier] NOT NULL,
			[nPromptColumnUID] [uniqueidentifier] NOT NULL,
			[cVariable] [nvarchar](50) NULL,
			[nOrdinal] [int] NOT NULL,
			[lRequired] [int] NOT NULL,
			[lReadOnly] [int] NOT NULL,
			[lMakeBlank] [int] NOT NULL,
			[lActive] [int] NOT NULL,
			[lDeleted] [int] NOT NULL,
			[lApproved] [int] NOT NULL,
			[lAdded] [int] NOT NULL,
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
		 CONSTRAINT [PK_PromptFields] PRIMARY KEY NONCLUSTERED
		(
			[nPromptFieldUID] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
		) ON [PRIMARY]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_nOrdinal]  DEFAULT (0) FOR [nOrdinal]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_lRequired]  DEFAULT (0) FOR [lRequired]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_lMakeBlank]  DEFAULT (0) FOR [lMakeBlank]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_lReadOnly]  DEFAULT (0) FOR [lReadOnly]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_lActive]  DEFAULT (-1) FOR [lActive]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_lDeleted]  DEFAULT (0) FOR [lDeleted]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_lApproved]  DEFAULT (0) FOR [lApproved]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_lAdded]  DEFAULT (-1) FOR [lAdded]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_nAddFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nAddFacilityUID]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_nAddUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nAddUserUID]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_tAddTime]  DEFAULT (GETUTCDATE()) FOR [tAddTime]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_nUpdateFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nUpdateFacilityUID]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_nUpdateUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nUpdateUserUID]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_tUpdateTime]  DEFAULT (GETUTCDATE()) FOR [tUpdateTime]

		ALTER TABLE [dbo].[PromptFields] ADD  CONSTRAINT [DF_PromptFields_tMobileTime]  DEFAULT (GETUTCDATE()) FOR [tMobileTime]

		ALTER TABLE [dbo].[PromptFields]  WITH CHECK ADD  CONSTRAINT [FK_PromptFields_Prompts]  FOREIGN KEY ([nPromptUID]) REFERENCES [dbo].[Prompts] ([nPromptUID])

		ALTER TABLE [dbo].[PromptFields]  WITH CHECK ADD  CONSTRAINT [FK_PromptFields_PromptColumns]  FOREIGN KEY ([nPromptColumnUID]) REFERENCES [dbo].[PromptColumns] ([nPromptColumnUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique system identifier used by the system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nPromptFieldUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to Prompts' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nPromptUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to Prompt Columns' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nPromptColumnUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Access to prompt variable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'cVariable'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Defines the sequence of prompt fields in the prompt' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nOrdinal'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not required; -1 or 1=required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'lRequired'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not readonly; -1 or 1=readonly' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'lReadOnly'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=retain value; -1 or 1=blank value' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'lMakeBlank'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=inactive; -1 or 1=active' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'lActive'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not deleted; -1 or 1=deleted' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'lDeleted'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not approved; -1 or 1=approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'lApproved'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not added; -1 or 1=added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'lAdded'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nAddFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the user that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nAddUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'tAddTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that last updated the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nUpdateFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the last user to update the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nUpdateUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'tUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for Mobile mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'tMobileTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for the Warehouse' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'tSystemUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If imported, contains UID of the import record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields', @level2type=N'COLUMN',@level2name=N'nImportUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains fields for prompt configurations for MET/CAL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PromptFields'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF NOT EXISTS (SELECT * FROM [dbo].[PromptTypes] WHERE [nPromptTypeUID] = '9361A172-ACD7-4E20-8E50-A21D1F413915') BEGIN INSERT INTO [dbo].[PromptTypes] ([nPromptTypeUID],[cPromptTypeDisplay],[nPromptValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID]) VALUES ('9361A172-ACD7-4E20-8E50-A21D1F413915', N'PRE_PROMPT', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220404 15:50:05.733','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220404 15:50:05.733','20220404 15:50:05.733', NULL, NULL) END
	IF NOT EXISTS (SELECT * FROM [dbo].[PromptTypes] WHERE [nPromptTypeUID] = '4331073F-5280-4DB6-8702-86E0B282332B') BEGIN INSERT INTO [dbo].[PromptTypes] ([nPromptTypeUID],[cPromptTypeDisplay],[nPromptValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID]) VALUES ('4331073F-5280-4DB6-8702-86E0B282332B', N'PASS_PROMPT', -1, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220404 15:50:05.733','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220404 15:50:05.733','20220404 15:50:05.733', NULL, NULL) END
	IF NOT EXISTS (SELECT * FROM [dbo].[PromptTypes] WHERE [nPromptTypeUID] = '75735A77-AA92-49BC-9483-42BBC358E31A') BEGIN INSERT INTO [dbo].[PromptTypes] ([nPromptTypeUID],[cPromptTypeDisplay],[nPromptValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID]) VALUES ('75735A77-AA92-49BC-9483-42BBC358E31A', N'FAIL_PROMPT', 0, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220404 15:50:05.733','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220404 15:50:05.733','20220404 15:50:05.733', NULL, NULL) END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptColumns_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_PromptColumns_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptColumns_RETRIEVE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptColumns_RETRIEVE
	Retrieves a single record by ID from the PromptColumns table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (R)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptColumns_RETRIEVE]

@nPromptColumnUID uniqueidentifier


AS
BEGIN

	SELECT
[nPromptColumnUID]
		,[nPromptTableUID]
		,[cColumnName]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[PromptColumns]
	WHERE
[nPromptColumnUID] = @nPromptColumnUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptColumns_LIST]'
		DROP PROCEDURE [dbo].[spl_PromptColumns_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptColumns_LIST]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptColumns_LIST
	Retrieves all records from the PromptColumns table
	Optionally includes inactive records
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (L)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptColumns_LIST]

@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nPromptColumnUID]
		,[nPromptTableUID]
		,[cColumnName]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[PromptColumns]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0

	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptColumns_INSERT]'
		DROP PROCEDURE [dbo].[spl_PromptColumns_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptColumns_INSERT]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptColumns_INSERT
	Inserts a new record into the PromptColumns table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (I)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptColumns_INSERT]

@nPromptTableUID uniqueidentifier
	,@cColumnName nvarchar(128)
	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398''
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172''
	,@nImportUID uniqueidentifier  = NULL

	,@nPromptColumnUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[PromptColumns] (
		[nPromptColumnUID]
,[nPromptTableUID]
		,[cColumnName]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nPromptTableUID
		,@cColumnName
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nPromptColumnUID = @ID

	-- Avoids warning in VS2010
	RETURN 1

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptColumns_DELETE]'
		DROP PROCEDURE [dbo].[spl_PromptColumns_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptColumns_DELETE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptColumns_DELETE
	Deletes a single record by ID from the PromptColumns table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptColumns_DELETE]

	@nPromptColumnUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT

AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nPromptColumnUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID )

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''PromptColumns'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT

	RETURN @retMsg

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptColumns_UPDATE]'
		DROP PROCEDURE [dbo].[spl_PromptColumns_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptColumns_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptColumns_UPDATE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptColumns_UPDATE
	Updates a single record by ID in the PromptColumns table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (U)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptColumns_UPDATE]

@nPromptColumnUID uniqueidentifier
	,@nPromptTableUID uniqueidentifier
	,@cColumnName nvarchar(128)
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[PromptColumns]
	SET
[nPromptTableUID] = @nPromptTableUID
		,[cColumnName] = @cColumnName
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nPromptColumnUID] = @nPromptColumnUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptFields_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_PromptFields_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptFields_RETRIEVE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptFields_RETRIEVE
	Retrieves a single record by ID from the PromptFields table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (R)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptFields_RETRIEVE]

@nPromptFieldUID uniqueidentifier


AS
BEGIN

	SELECT
[nPromptFieldUID]
		,[nPromptUID]
		,[nPromptColumnUID]
		,[cVariable]
		,[nOrdinal]
		,[lRequired]
		,[lReadOnly]
		,[lMakeBlank]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[PromptFields]
	WHERE
[nPromptFieldUID] = @nPromptFieldUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptFields_LIST]'
		DROP PROCEDURE [dbo].[spl_PromptFields_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptFields_LIST]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptFields_LIST
	Retrieves all records from the PromptFields table
	Optionally includes inactive records
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (L)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptFields_LIST]

@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nPromptFieldUID]
		,[nPromptUID]
		,[nPromptColumnUID]
		,[cVariable]
		,[nOrdinal]
		,[lRequired]
		,[lReadOnly]
		,[lMakeBlank]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[PromptFields]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0

	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptFields_INSERT]'
		DROP PROCEDURE [dbo].[spl_PromptFields_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptFields_INSERT]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptFields_INSERT
	Inserts a new record into the PromptFields table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (I)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptFields_INSERT]

@nPromptUID uniqueidentifier
	,@nPromptColumnUID uniqueidentifier
	,@cVariable nvarchar(50)  = NULL
	,@nOrdinal int  = 0
	,@lRequired int  = 0
	,@lReadOnly int  = 0
	,@lMakeBlank int  = 0
	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398''
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172''
	,@nImportUID uniqueidentifier  = NULL

	,@nPromptFieldUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[PromptFields] (
		[nPromptFieldUID]
,[nPromptUID]
		,[nPromptColumnUID]
		,[cVariable]
		,[nOrdinal]
		,[lRequired]
		,[lReadOnly]
		,[lMakeBlank]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nPromptUID
		,@nPromptColumnUID
		,@cVariable
		,@nOrdinal
		,@lRequired
		,@lReadOnly
		,@lMakeBlank
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nPromptFieldUID = @ID

	-- Avoids warning in VS2010
	RETURN 1

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptFields_DELETE]'
		DROP PROCEDURE [dbo].[spl_PromptFields_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptFields_DELETE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptFields_DELETE
	Deletes a single record by ID from the PromptFields table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptFields_DELETE]

	@nPromptFieldUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT

AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nPromptFieldUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID )

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''PromptFields'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT

	RETURN @retMsg

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_PromptFields_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptFields_UPDATE]'
		DROP PROCEDURE [dbo].[spl_PromptFields_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptFields_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptFields_UPDATE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptFields_UPDATE
	Updates a single record by ID in the PromptFields table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (U)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptFields_UPDATE]

@nPromptFieldUID uniqueidentifier
	,@nPromptUID uniqueidentifier
	,@nPromptColumnUID uniqueidentifier
	,@cVariable nvarchar(50)
	,@nOrdinal int
	,@lRequired int
	,@lReadOnly int
	,@lMakeBlank int
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[PromptFields]
	SET
[nPromptUID] = @nPromptUID
		,[nPromptColumnUID] = @nPromptColumnUID
		,[cVariable] = @cVariable
		,[nOrdinal] = @nOrdinal
		,[lRequired] = @lRequired
		,[lReadOnly] = @lReadOnly
		,[lMakeBlank] = @lMakeBlank
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nPromptFieldUID] = @nPromptFieldUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Prompts_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_Prompts_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Prompts_RETRIEVE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Prompts_RETRIEVE
	Retrieves a single record by ID from the Prompts table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (R)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Prompts_RETRIEVE]

@nPromptUID uniqueidentifier


AS
BEGIN

	SELECT
[nPromptUID]
		,[nPromptTypeUID]
		,[cPromptName]
		,[mNotes]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[Prompts]
	WHERE
[nPromptUID] = @nPromptUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Prompts_LIST]'
		DROP PROCEDURE [dbo].[spl_Prompts_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Prompts_LIST]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Prompts_LIST
	Retrieves all records from the Prompts table
	Optionally includes inactive records
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (L)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Prompts_LIST]

@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nPromptUID]
		,[nPromptTypeUID]
		,[cPromptName]
		,[mNotes]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[Prompts]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0

	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Prompts_INSERT]'
		DROP PROCEDURE [dbo].[spl_Prompts_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Prompts_INSERT]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Prompts_INSERT
	Inserts a new record into the Prompts table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (I)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Prompts_INSERT]

@nPromptTypeUID uniqueidentifier
	,@cPromptName nvarchar(150)
	,@mNotes nvarchar(max)  = NULL
	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398''
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172''
	,@nImportUID uniqueidentifier  = NULL

	,@nPromptUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[Prompts] (
		[nPromptUID]
,[nPromptTypeUID]
		,[cPromptName]
		,[mNotes]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nPromptTypeUID
		,@cPromptName
		,@mNotes
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nPromptUID = @ID

	-- Avoids warning in VS2010
	RETURN 1

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Prompts_DELETE]'
		DROP PROCEDURE [dbo].[spl_Prompts_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Prompts_DELETE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Prompts_DELETE
	Deletes a single record by ID from the Prompts table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Prompts_DELETE]

	@nPromptUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT

AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nPromptUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID )

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''Prompts'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT

	RETURN @retMsg

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_Prompts_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Prompts_UPDATE]'
		DROP PROCEDURE [dbo].[spl_Prompts_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Prompts_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Prompts_UPDATE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Prompts_UPDATE
	Updates a single record by ID in the Prompts table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (U)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Prompts_UPDATE]

@nPromptUID uniqueidentifier
	,@nPromptTypeUID uniqueidentifier
	,@cPromptName nvarchar(150)
	,@mNotes nvarchar(max)
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[Prompts]
	SET
[nPromptTypeUID] = @nPromptTypeUID
		,[cPromptName] = @cPromptName
		,[mNotes] = @mNotes
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nPromptUID] = @nPromptUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTables_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_PromptTables_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTables_RETRIEVE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTables_RETRIEVE
	Retrieves a single record by ID from the PromptTables table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (R)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTables_RETRIEVE]

@nPromptTableUID uniqueidentifier


AS
BEGIN

	SELECT
[nPromptTableUID]
		,[cTableName]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[PromptTables]
	WHERE
[nPromptTableUID] = @nPromptTableUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTables_LIST]'
		DROP PROCEDURE [dbo].[spl_PromptTables_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTables_LIST]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTables_LIST
	Retrieves all records from the PromptTables table
	Optionally includes inactive records
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (L)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTables_LIST]

@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nPromptTableUID]
		,[cTableName]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[PromptTables]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0

	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTables_INSERT]'
		DROP PROCEDURE [dbo].[spl_PromptTables_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTables_INSERT]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTables_INSERT
	Inserts a new record into the PromptTables table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (I)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTables_INSERT]

@cTableName nvarchar(128)
	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398''
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172''
	,@nImportUID uniqueidentifier  = NULL

	,@nPromptTableUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[PromptTables] (
		[nPromptTableUID]
,[cTableName]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@cTableName
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nPromptTableUID = @ID

	-- Avoids warning in VS2010
	RETURN 1

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTables_DELETE]'
		DROP PROCEDURE [dbo].[spl_PromptTables_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTables_DELETE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTables_DELETE
	Deletes a single record by ID from the PromptTables table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTables_DELETE]

	@nPromptTableUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT

AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nPromptTableUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID )

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''PromptTables'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT

	RETURN @retMsg

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_PromptTables_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTables_UPDATE]'
		DROP PROCEDURE [dbo].[spl_PromptTables_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTables_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTables_UPDATE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTables_UPDATE
	Updates a single record by ID in the PromptTables table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (U)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTables_UPDATE]

@nPromptTableUID uniqueidentifier
	,@cTableName nvarchar(128)
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[PromptTables]
	SET
[cTableName] = @cTableName
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nPromptTableUID] = @nPromptTableUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTypes_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_PromptTypes_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTypes_RETRIEVE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTypes_RETRIEVE
	Retrieves a single record by ID from the PromptTypes table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (R)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTypes_RETRIEVE]

@nPromptTypeUID uniqueidentifier


AS
BEGIN

	SELECT
[nPromptTypeUID]
		,[cPromptTypeDisplay]
		,[nPromptValue]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[PromptTypes]
	WHERE
[nPromptTypeUID] = @nPromptTypeUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTypes_LIST]'
		DROP PROCEDURE [dbo].[spl_PromptTypes_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTypes_LIST]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTypes_LIST
	Retrieves all records from the PromptTypes table
	Optionally includes inactive records
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (L)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTypes_LIST]

@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nPromptTypeUID]
		,[cPromptTypeDisplay]
		,[nPromptValue]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[PromptTypes]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0

	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTypes_INSERT]'
		DROP PROCEDURE [dbo].[spl_PromptTypes_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTypes_INSERT]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTypes_INSERT
	Inserts a new record into the PromptTypes table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (I)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTypes_INSERT]

@cPromptTypeDisplay nvarchar(20)
	,@nPromptValue int  = NULL
	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398''
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172''
	,@nImportUID uniqueidentifier  = NULL

	,@nPromptTypeUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[PromptTypes] (
		[nPromptTypeUID]
,[cPromptTypeDisplay]
		,[nPromptValue]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@cPromptTypeDisplay
		,@nPromptValue
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nPromptTypeUID = @ID

	-- Avoids warning in VS2010
	RETURN 1

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTypes_DELETE]'
		DROP PROCEDURE [dbo].[spl_PromptTypes_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTypes_DELETE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTypes_DELETE
	Deletes a single record by ID from the PromptTypes table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTypes_DELETE]

	@nPromptTypeUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT

AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nPromptTypeUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID )

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''PromptTypes'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT

	RETURN @retMsg

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_PromptTypes_UPDATE]'
		DROP PROCEDURE [dbo].[spl_PromptTypes_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_PromptTypes_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_PromptTypes_UPDATE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_PromptTypes_UPDATE
	Updates a single record by ID in the PromptTypes table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 4/4/2022 (U)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_PromptTypes_UPDATE]

@nPromptTypeUID uniqueidentifier
	,@cPromptTypeDisplay nvarchar(20)
	,@nPromptValue int
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[PromptTypes]
	SET
[cPromptTypeDisplay] = @cPromptTypeDisplay
		,[nPromptValue] = @nPromptValue
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nPromptTypeUID] = @nPromptTypeUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


    IF NOT EXISTS(SELECT * FROM [dbo].[AuditTables] WHERE [TableID] = 87)
    BEGIN
        PRINT 'Adding table [Prompts] to [AuditTables]'

        SET IDENTITY_INSERT [dbo].[AuditTables] ON
        INSERT INTO [dbo].[AuditTables] ([TableID], [Owner], [TableName], [AuditTable], [AuditInserts], [AuditUpdates], [AuditDeletes], [AuditDeletesAll], [UniqueKeyType], [UserColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES (87, N'dbo', N'Prompts', 1, 1, 1, 0, 1, 'P', N' ', -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditTables] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '53a3dcda-af55-474c-b6c7-4f8744c288d9')
    BEGIN
        PRINT 'Adding column [Prompts].[nPromptUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('53a3dcda-af55-474c-b6c7-4f8744c288d9', 87, 3096, N'nPromptUID', 1, 0, 0, 1, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '3418beeb-05a9-4cd0-911e-db6dfb808058')
    BEGIN
        PRINT 'Adding column [Prompts].[nPromptTypeUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('3418beeb-05a9-4cd0-911e-db6dfb808058', 87, 3097, N'nPromptTypeUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '9f4a88d0-3ba6-4c6c-9127-7fd9d619d1c7')
    BEGIN
        PRINT 'Adding column [Prompts].[cPromptName] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('9f4a88d0-3ba6-4c6c-9127-7fd9d619d1c7', 87, 3098, N'cPromptName', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'd6f162fa-a37f-4b98-9c21-addf73c51265')
    BEGIN
        PRINT 'Adding column [Prompts].[mNotes] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('d6f162fa-a37f-4b98-9c21-addf73c51265', 87, 3099, N'mNotes', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '802469b6-096d-46ff-b9da-565b04dc7335')
    BEGIN
        PRINT 'Adding column [Prompts].[lActive] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('802469b6-096d-46ff-b9da-565b04dc7335', 87, 3100, N'lActive', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '7f519041-68e1-43e6-bcb9-d49a4d4be921')
    BEGIN
        PRINT 'Adding column [Prompts].[lDeleted] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('7f519041-68e1-43e6-bcb9-d49a4d4be921', 87, 3101, N'lDeleted', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'b3ebca9c-432a-4ab2-b652-9bf2ece36ce8')
    BEGIN
        PRINT 'Adding column [Prompts].[lApproved] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('b3ebca9c-432a-4ab2-b652-9bf2ece36ce8', 87, 3102, N'lApproved', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'e9abafd2-3aed-481c-9b6c-65a03ab2a247')
    BEGIN
        PRINT 'Adding column [Prompts].[lAdded] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('e9abafd2-3aed-481c-9b6c-65a03ab2a247', 87, 3103, N'lAdded', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '845ad53b-cb69-4fd0-9d24-45ad72260f59')
    BEGIN
        PRINT 'Adding column [Prompts].[nAddFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('845ad53b-cb69-4fd0-9d24-45ad72260f59', 87, 3104, N'nAddFacilityUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '1f232867-0f05-483f-9936-0eb0c775df65')
    BEGIN
        PRINT 'Adding column [Prompts].[nAddUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('1f232867-0f05-483f-9936-0eb0c775df65', 87, 3105, N'nAddUserUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '5f135bd1-a9d2-44cc-a893-c3294cdfda9c')
    BEGIN
        PRINT 'Adding column [Prompts].[tAddTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('5f135bd1-a9d2-44cc-a893-c3294cdfda9c', 87, 3106, N'tAddTime', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'e2ab7085-edaa-4477-923a-4fa592173943')
    BEGIN
        PRINT 'Adding column [Prompts].[nUpdateFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('e2ab7085-edaa-4477-923a-4fa592173943', 87, 3107, N'nUpdateFacilityUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '9b6ee2b4-422b-4dcf-b864-a1aec9b38c29')
    BEGIN
        PRINT 'Adding column [Prompts].[nUpdateUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('9b6ee2b4-422b-4dcf-b864-a1aec9b38c29', 87, 3108, N'nUpdateUserUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '4636b158-69c5-4885-a7b3-015b1adf45a9')
    BEGIN
        PRINT 'Adding column [Prompts].[tUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('4636b158-69c5-4885-a7b3-015b1adf45a9', 87, 3109, N'tUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '05347f19-cedf-4b2c-93d2-b74662b0e3d3')
    BEGIN
        PRINT 'Adding column [Prompts].[tMobileTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('05347f19-cedf-4b2c-93d2-b74662b0e3d3', 87, 3110, N'tMobileTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '0e96e908-b764-41ef-899c-7779b5f6e816')
    BEGIN
        PRINT 'Adding column [Prompts].[tSystemUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('0e96e908-b764-41ef-899c-7779b5f6e816', 87, 3111, N'tSystemUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '8b0f408f-a01f-4e99-96eb-18f7b546949b')
    BEGIN
        PRINT 'Adding column [Prompts].[nImportUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('8b0f408f-a01f-4e99-96eb-18f7b546949b', 87, 3112, N'nImportUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:37:23', '20220404 22:37:23', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Prompts_Del]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Prompts_Del] from [dbo].[Prompts]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Prompts_Del]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Prompts_Del]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Prompts_Del] on [dbo].[Prompts]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Prompts_Del] ON [dbo].[Prompts] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20220404 22:37:23

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3098,
            0,
            CONVERT( NVARCHAR(max), [cPromptName] )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3100,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3103,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3102,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3101,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3099,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3104,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3105,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3112,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3097,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptTypeUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3096,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3107,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3108,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3106,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3110,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3111,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3109,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 87, @RowsAffected, ''D'', @AuditedUser
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Prompts_Del]', 'last', 'delete', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Prompts_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Prompts_Ins] from [dbo].[Prompts]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Prompts_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Prompts_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Prompts_Ins] on [dbo].[Prompts]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Prompts_Ins] ON [dbo].[Prompts] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20220404 22:37:23

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3098,
            0,
            CONVERT( NVARCHAR(max), [cPromptName] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3100,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3103,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3102,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3101,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3099,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3104,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3105,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3097,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptTypeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3096,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptUID='' + CONVERT(VARCHAR( 36 ), [nPromptUID]),
            3106,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 87, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Prompts_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Prompts_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Prompts_Upd] from [dbo].[Prompts]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Prompts_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Prompts_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Prompts_Upd] on [dbo].[Prompts]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Prompts_Upd] ON [dbo].[Prompts] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20220404 22:37:23

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cPromptName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3098,
                0,
                CONVERT( NVARCHAR(max), d.[cPromptName] ),
                CONVERT( NVARCHAR(max), i.[cPromptName] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[cPromptName] <> i.[cPromptName] ) OR
                ( d.[cPromptName] IS NULL AND i.[cPromptName] IS NOT NULL ) OR
                ( i.[cPromptName] IS NULL AND d.[cPromptName] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3100,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3103,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3102,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3101,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3099,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3104,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3105,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nPromptTypeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3097,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nPromptTypeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nPromptTypeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[nPromptTypeUID] <> i.[nPromptTypeUID] ) OR
                ( d.[nPromptTypeUID] IS NULL AND i.[nPromptTypeUID] IS NOT NULL ) OR
                ( i.[nPromptTypeUID] IS NULL AND d.[nPromptTypeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nPromptUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3096,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nPromptUID]),
                CONVERT(NVARCHAR( 36 ), i.[nPromptUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[nPromptUID] <> i.[nPromptUID] ) OR
                ( d.[nPromptUID] IS NULL AND i.[nPromptUID] IS NOT NULL ) OR
                ( i.[nPromptUID] IS NULL AND d.[nPromptUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptUID], d.[nPromptUID] )),
                3106,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptUID] = i.[nPromptUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 87, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Prompts_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditTables] WHERE [TableID] = 88)
    BEGIN
        PRINT 'Adding table [PromptFields] to [AuditTables]'

        SET IDENTITY_INSERT [dbo].[AuditTables] ON
        INSERT INTO [dbo].[AuditTables] ([TableID], [Owner], [TableName], [AuditTable], [AuditInserts], [AuditUpdates], [AuditDeletes], [AuditDeletesAll], [UniqueKeyType], [UserColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES (88, N'dbo', N'PromptFields', 1, 1, 1, 0, 1, 'P', N' ', -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditTables] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '77e57ffd-2e7a-40c4-a7f6-6dcd1a35c597')
    BEGIN
        PRINT 'Adding column [PromptFields].[nPromptFieldUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('77e57ffd-2e7a-40c4-a7f6-6dcd1a35c597', 88, 3113, N'nPromptFieldUID', 1, 0, 0, 1, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '38ee0c52-4bd1-49f2-8d57-9665fc783398')
    BEGIN
        PRINT 'Adding column [PromptFields].[nPromptUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('38ee0c52-4bd1-49f2-8d57-9665fc783398', 88, 3114, N'nPromptUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '8fc01fed-d61a-4a33-a012-84f7a41d4812')
    BEGIN
        PRINT 'Adding column [PromptFields].[nPromptColumnUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('8fc01fed-d61a-4a33-a012-84f7a41d4812', 88, 3115, N'nPromptColumnUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '846b8e19-191d-4fe1-a5d4-6e8cd4a20c9f')
    BEGIN
        PRINT 'Adding column [PromptFields].[cVariable] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('846b8e19-191d-4fe1-a5d4-6e8cd4a20c9f', 88, 3116, N'cVariable', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '8f59db6d-2ff4-427b-b912-a3498d5e2fed')
    BEGIN
        PRINT 'Adding column [PromptFields].[nOrdinal] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('8f59db6d-2ff4-427b-b912-a3498d5e2fed', 88, 3117, N'nOrdinal', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '0dea7b35-7727-4e54-bd90-80c624601259')
    BEGIN
        PRINT 'Adding column [PromptFields].[lRequired] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('0dea7b35-7727-4e54-bd90-80c624601259', 88, 3118, N'lRequired', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '60136b48-ec5c-4ed3-bb6b-c426adfa661d')
    BEGIN
        PRINT 'Adding column [PromptFields].[lReadOnly] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('60136b48-ec5c-4ed3-bb6b-c426adfa661d', 88, 3119, N'lReadOnly', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '8e3a9d86-027d-43c4-966f-0d9115fafd1c')
    BEGIN
        PRINT 'Adding column [PromptFields].[lMakeBlank] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('8e3a9d86-027d-43c4-966f-0d9115fafd1c', 88, 3120, N'lMakeBlank', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '1597a78a-c2ff-44d3-9773-cf84c2dfe199')
    BEGIN
        PRINT 'Adding column [PromptFields].[lActive] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('1597a78a-c2ff-44d3-9773-cf84c2dfe199', 88, 3121, N'lActive', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'eed95269-3c8c-4347-906d-9863c7f9fbec')
    BEGIN
        PRINT 'Adding column [PromptFields].[lDeleted] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('eed95269-3c8c-4347-906d-9863c7f9fbec', 88, 3122, N'lDeleted', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '1f990dd6-65c9-4549-b4e0-312226681ad7')
    BEGIN
        PRINT 'Adding column [PromptFields].[lApproved] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('1f990dd6-65c9-4549-b4e0-312226681ad7', 88, 3123, N'lApproved', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'cf1e6763-a84f-4e69-9946-882e79583150')
    BEGIN
        PRINT 'Adding column [PromptFields].[lAdded] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('cf1e6763-a84f-4e69-9946-882e79583150', 88, 3124, N'lAdded', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'c96e7201-6fda-4982-9d7c-640c29c6683b')
    BEGIN
        PRINT 'Adding column [PromptFields].[nAddFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('c96e7201-6fda-4982-9d7c-640c29c6683b', 88, 3125, N'nAddFacilityUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '7549caa1-a76b-4f47-b57c-f3e1a87a4dba')
    BEGIN
        PRINT 'Adding column [PromptFields].[nAddUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('7549caa1-a76b-4f47-b57c-f3e1a87a4dba', 88, 3126, N'nAddUserUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '39a9fe39-e0b5-4ee8-ac74-90a2f0d38fab')
    BEGIN
        PRINT 'Adding column [PromptFields].[tAddTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('39a9fe39-e0b5-4ee8-ac74-90a2f0d38fab', 88, 3127, N'tAddTime', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '9bda8c36-854c-4ff8-af47-f58a457410e2')
    BEGIN
        PRINT 'Adding column [PromptFields].[nUpdateFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('9bda8c36-854c-4ff8-af47-f58a457410e2', 88, 3128, N'nUpdateFacilityUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'a2402c9f-b447-47f7-8a6b-56f82f20f157')
    BEGIN
        PRINT 'Adding column [PromptFields].[nUpdateUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('a2402c9f-b447-47f7-8a6b-56f82f20f157', 88, 3129, N'nUpdateUserUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '47bbd2b4-e931-4302-8a88-181e5d7750a3')
    BEGIN
        PRINT 'Adding column [PromptFields].[tUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('47bbd2b4-e931-4302-8a88-181e5d7750a3', 88, 3130, N'tUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'ef4948ab-ff27-4996-9eb5-f97f0d0fdb0a')
    BEGIN
        PRINT 'Adding column [PromptFields].[tMobileTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('ef4948ab-ff27-4996-9eb5-f97f0d0fdb0a', 88, 3131, N'tMobileTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '3d87f444-c2be-42f9-9ff3-2cdc35e40103')
    BEGIN
        PRINT 'Adding column [PromptFields].[tSystemUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('3d87f444-c2be-42f9-9ff3-2cdc35e40103', 88, 3132, N'tSystemUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'bd806748-7851-461e-9ab2-10f7834ed647')
    BEGIN
        PRINT 'Adding column [PromptFields].[nImportUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('bd806748-7851-461e-9ab2-10f7834ed647', 88, 3133, N'nImportUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220404 22:40:15', '20220404 22:40:15', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_PromptFields_Del]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_PromptFields_Del] from [dbo].[PromptFields]'

    	DROP TRIGGER [dbo].[tr_kr_audit_PromptFields_Del]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_PromptFields_Del]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_PromptFields_Del] on [dbo].[PromptFields]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_PromptFields_Del] ON [dbo].[PromptFields] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20220404 22:40:15

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3116,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cVariable], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3121,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3124,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3123,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3122,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3120,
            0,
            CONVERT(NVARCHAR, [lMakeBlank])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3119,
            0,
            CONVERT(NVARCHAR, [lReadOnly])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3118,
            0,
            CONVERT(NVARCHAR, [lRequired])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3125,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3126,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3133,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3117,
            0,
            CONVERT(NVARCHAR, [nOrdinal])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3115,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptColumnUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3113,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptFieldUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3114,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3128,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3129,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3127,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3131,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3132,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3130,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 88, @RowsAffected, ''D'', @AuditedUser
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_PromptFields_Del]', 'last', 'delete', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_PromptFields_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_PromptFields_Ins] from [dbo].[PromptFields]'

    	DROP TRIGGER [dbo].[tr_kr_audit_PromptFields_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_PromptFields_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_PromptFields_Ins] on [dbo].[PromptFields]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_PromptFields_Ins] ON [dbo].[PromptFields] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20220404 22:40:15

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3116,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cVariable], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3121,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3124,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3123,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3122,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3120,
            0,
            CONVERT(NVARCHAR, [lMakeBlank])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3119,
            0,
            CONVERT(NVARCHAR, [lReadOnly])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3118,
            0,
            CONVERT(NVARCHAR, [lRequired])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3125,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3126,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3117,
            0,
            CONVERT(NVARCHAR, [nOrdinal])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3115,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptColumnUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3113,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptFieldUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3114,
            0,
            CONVERT(NVARCHAR( 36 ), [nPromptUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), [nPromptFieldUID]),
            3127,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 88, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_PromptFields_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_PromptFields_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_PromptFields_Upd] from [dbo].[PromptFields]'

    	DROP TRIGGER [dbo].[tr_kr_audit_PromptFields_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_PromptFields_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_PromptFields_Upd] on [dbo].[PromptFields]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_PromptFields_Upd] ON [dbo].[PromptFields] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20220404 22:40:15

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cVariable] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3116,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cVariable], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cVariable], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( NULLIF(d.[cVariable], '''') <> NULLIF(i.[cVariable], '''') ) OR
                ( NULLIF(d.[cVariable], '''') IS NULL AND NULLIF(i.[cVariable], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cVariable], '''') IS NULL AND NULLIF(d.[cVariable], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3121,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3124,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3123,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3122,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lMakeBlank] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3120,
                0,
                CONVERT(NVARCHAR, d.[lMakeBlank]),
                CONVERT(NVARCHAR, i.[lMakeBlank])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[lMakeBlank] <> i.[lMakeBlank] ) OR
                ( d.[lMakeBlank] IS NULL AND i.[lMakeBlank] IS NOT NULL ) OR
                ( i.[lMakeBlank] IS NULL AND d.[lMakeBlank] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lReadOnly] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3119,
                0,
                CONVERT(NVARCHAR, d.[lReadOnly]),
                CONVERT(NVARCHAR, i.[lReadOnly])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[lReadOnly] <> i.[lReadOnly] ) OR
                ( d.[lReadOnly] IS NULL AND i.[lReadOnly] IS NOT NULL ) OR
                ( i.[lReadOnly] IS NULL AND d.[lReadOnly] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lRequired] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3118,
                0,
                CONVERT(NVARCHAR, d.[lRequired]),
                CONVERT(NVARCHAR, i.[lRequired])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[lRequired] <> i.[lRequired] ) OR
                ( d.[lRequired] IS NULL AND i.[lRequired] IS NOT NULL ) OR
                ( i.[lRequired] IS NULL AND d.[lRequired] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3125,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3126,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nOrdinal] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3117,
                0,
                CONVERT(NVARCHAR, d.[nOrdinal]),
                CONVERT(NVARCHAR, i.[nOrdinal])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[nOrdinal] <> i.[nOrdinal] ) OR
                ( d.[nOrdinal] IS NULL AND i.[nOrdinal] IS NOT NULL ) OR
                ( i.[nOrdinal] IS NULL AND d.[nOrdinal] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nPromptColumnUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3115,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nPromptColumnUID]),
                CONVERT(NVARCHAR( 36 ), i.[nPromptColumnUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[nPromptColumnUID] <> i.[nPromptColumnUID] ) OR
                ( d.[nPromptColumnUID] IS NULL AND i.[nPromptColumnUID] IS NOT NULL ) OR
                ( i.[nPromptColumnUID] IS NULL AND d.[nPromptColumnUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nPromptFieldUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3113,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nPromptFieldUID]),
                CONVERT(NVARCHAR( 36 ), i.[nPromptFieldUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[nPromptFieldUID] <> i.[nPromptFieldUID] ) OR
                ( d.[nPromptFieldUID] IS NULL AND i.[nPromptFieldUID] IS NOT NULL ) OR
                ( i.[nPromptFieldUID] IS NULL AND d.[nPromptFieldUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nPromptUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3114,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nPromptUID]),
                CONVERT(NVARCHAR( 36 ), i.[nPromptUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[nPromptUID] <> i.[nPromptUID] ) OR
                ( d.[nPromptUID] IS NULL AND i.[nPromptUID] IS NOT NULL ) OR
                ( i.[nPromptUID] IS NULL AND d.[nPromptUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nPromptFieldUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nPromptFieldUID], d.[nPromptFieldUID] )),
                3127,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nPromptFieldUID] = i.[nPromptFieldUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 88, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_PromptFields_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_Prompts' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_Prompts]'

		DROP VIEW [dbo].[vw_Prompts]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_Prompts]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_Prompts]'

		EXEC sp_executesql N'
/*****************************************************************************************************************
	vw_Prompts

	(C) 2022 Fluke Calibration
------------------------------------------------------------------------------------------------------------------
	CHANGE HISTORY
	04/07/2022  MM  Initial Version
*****************************************************************************************************************/
CREATE VIEW [dbo].[vw_Prompts]
AS
SELECT
	pr.[nPromptUID],
	pr.[nPromptTypeUID],
	pr.[cPromptName],
	pr.[mNotes],
	pr.[lActive],
	prt.[cPromptTypeDisplay],
	prt.[nPromptValue]
FROM
	[dbo].[Prompts] pr
JOIN
	[dbo].[PromptTypes] prt ON prt.[nPromptTypeUID] = pr.[nPromptTypeUID]
WHERE
	pr.[lDeleted] = 0
AND
	prt.[lActive] <> 0
AND
	prt.[lDeleted] = 0
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Context] WHERE nContextUID = 'bfdb85f7-e95e-4330-8f57-94655940be5e')
	BEGIN
	    PRINT N'Adding context for FindPrompt'
	    INSERT INTO [dbo].[Context]([nContextUID],[cContext],[cMode],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('bfdb85f7-e95e-4330-8f57-94655940be5e',N'FindPrompt',N'System',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '02bb0801-f646-4247-8254-611dc1734a3d')
	BEGIN
	    PRINT N'Adding UCI Data Item for cPromptName'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('02bb0801-f646-4247-8254-611dc1734a3d', N'Prompts', N'cPromptName', N'Label', N'Prompt Name',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '136ff0a5-8fbf-4c42-85d3-c90d0ebfbc95')
	BEGIN
	    PRINT N'Adding Context Element for cPromptName'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('136ff0a5-8fbf-4c42-85d3-c90d0ebfbc95','02bb0801-f646-4247-8254-611dc1734a3d',N'Field',N'cPromptName',N'Prompt Name',200,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '9152c439-d467-4128-ab49-ac9747d7caaa')
	BEGIN
	    PRINT N'Adding Context Element Link for cPromptName'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('9152c439-d467-4128-ab49-ac9747d7caaa','bfdb85f7-e95e-4330-8f57-94655940be5e','136ff0a5-8fbf-4c42-85d3-c90d0ebfbc95',N'AND',1,0,NULL,-1,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'e6f66501-4a19-41a7-b782-c89b3a82262a')
	BEGIN
	    PRINT N'Adding UCI Data Item for mNotes'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e6f66501-4a19-41a7-b782-c89b3a82262a', N'Prompts', N'mNotes', N'Label', N'Notes',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4de94dce-9088-4d44-bd75-9e8ab6a9d14d')
	BEGIN
	    PRINT N'Adding Context Element for mNotes'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('4de94dce-9088-4d44-bd75-9e8ab6a9d14d','e6f66501-4a19-41a7-b782-c89b3a82262a',N'Field',N'mNotes',N'Notes',500,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '87952c8a-7260-4a12-b7ee-54774a8b22a2')
	BEGIN
	    PRINT N'Adding Context Element Link for mNotes'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('87952c8a-7260-4a12-b7ee-54774a8b22a2','bfdb85f7-e95e-4330-8f57-94655940be5e','4de94dce-9088-4d44-bd75-9e8ab6a9d14d',N'AND',2,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'da4649f3-8c5e-4c3d-b31a-e12b2621ebfe')
	BEGIN
	    PRINT N'Adding UCI Data Item for lActive'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('da4649f3-8c5e-4c3d-b31a-e12b2621ebfe', N'Prompts', N'lActive', N'Label', N'Active',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '82feb712-160f-4175-af79-e9fbce494d5e')
	BEGIN
	    PRINT N'Adding Context Element for lActive'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('82feb712-160f-4175-af79-e9fbce494d5e','da4649f3-8c5e-4c3d-b31a-e12b2621ebfe',N'Field',N'lActive',N'Active',64,NULL,NULL,NULL,3,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '36f4bc2c-1072-4e30-bf6f-05a974be3c36')
	BEGIN
	    PRINT N'Adding Context Element Link for lActive'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('36f4bc2c-1072-4e30-bf6f-05a974be3c36','bfdb85f7-e95e-4330-8f57-94655940be5e','82feb712-160f-4175-af79-e9fbce494d5e',N'AND',3,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '5d2d74c0-3080-4935-8d69-6babc39087f6')
	BEGIN
	    PRINT N'Adding UCI Data Item for cPromptTypeDisplay'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5d2d74c0-3080-4935-8d69-6babc39087f6', N'Prompts', N'cPromptTypeDisplay', N'Label', N'Prompt Type',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ff7f75be-4768-4cc5-aba2-238ff6cf6580')
	BEGIN
	    PRINT N'Adding Context Element for cPromptTypeDisplay'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ff7f75be-4768-4cc5-aba2-238ff6cf6580','5d2d74c0-3080-4935-8d69-6babc39087f6',N'Field',N'cPromptTypeDisplay',N'Prompt Type',129,NULL,NULL,NULL,1,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '148c26dc-49b8-4aa9-b3a8-111317799497')
	BEGIN
	    PRINT N'Adding Context Element Link for cPromptTypeDisplay'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('148c26dc-49b8-4aa9-b3a8-111317799497','bfdb85f7-e95e-4330-8f57-94655940be5e','ff7f75be-4768-4cc5-aba2-238ff6cf6580',N'AND',4,0,NULL,-1,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '46153f21-4f3c-41ff-8d37-708e17774e02')
	BEGIN
	    PRINT N'Adding Context Element for SELECT strFields FROM vw_Prompts'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('46153f21-4f3c-41ff-8d37-708e17774e02',NULL,N'Select',N'SELECT strFields, nPromptUID AS [UID] FROM vw_Prompts strWhere strOrder ',NULL,NULL,NULL,NULL,NULL,0,NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '475fc86b-6704-4ea0-804f-9ac5968a77b7')
	BEGIN
	    PRINT N'Adding Context Element Link for SELECT strFields FROM vw_Prompts'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('475fc86b-6704-4ea0-804f-9ac5968a77b7','bfdb85f7-e95e-4330-8f57-94655940be5e','46153f21-4f3c-41ff-8d37-708e17774e02',NULL,NULL,0,NULL,0,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220407 21:15:29.000','20220407 21:15:29.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-7699<<--
	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MCRT]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_MCRT]'
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_MCRT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MCRT]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_MCRT]'

		EXEC sp_executesql N'/********************************************************************************
				udf_GetMETCAL_Results_MCRT
				Gets the MET/CAL results data for the Runtime view

				Parameters:
				@nCallSheetResultUID - UID for call sheet result record

				(C) 2016-2022 Fluke Calibration
			-----------------------------------------------------------------
				CHANGE HISTORY
				09/21/2016  MM      Initially created
				11/30/2021  AC      Account for Marginal condition in RESULT column
				12/15/2021  AC      Changed PERCENT_TOL field to return >500 % when nToleranceErrorPercent > 500
				04/11/2022  AC      Place all nToleranceErrorPercent statements on a single line to support Editing Results

                NOTES: All of the statements that make up one fields formatting MUST be on a single line.
                       Test editing results in MET/TEAM after adding or altering any field.
			*********************************************************************************/

				CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_MCRT] ( @nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17'' )      -- new record GUID
				RETURNS TABLE
				AS
				RETURN
				(
					SELECT
						p.nPointUID,
						p.nPointOrdinal AS [ROW NUMBER],
						COALESCE(p.cPointPassFailStatus,'''') + '' '' + COALESCE(p.cCondition,'''') AS [RESULT],
						pes.cField009 AS [NO],
						COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUTRange, p.nUUTRangeFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTRangeUnitUID),'''') AS [RANGE],
						COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUT, p.nUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTUnitUID),'''') AS [UUT_INDICATED],
						COALESCE([dbo].[udf_GET_FormattedValueEx](p.nReference, p.nReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nReferenceUnitUID),'''') AS [SYSTEM_ACTUAL],
						pel.lField001 AS [C],
						COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nModifier1, pun.nModifier1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nModifier1UnitUID),'''') AS [MODIFIER],
						COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nError, tol.nErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nErrorUnitUID),'''') AS [ERROR],
						CASE WHEN tol.nToleranceErrorPercent > 500 THEN ''>500 %'' ELSE COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nToleranceErrorPercent IS NULL THEN '''' ELSE '' %'' END END AS [PERCENT_TOL]
					FROM
						CallSheetResults csr
						LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
						LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
						LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
						LEFT JOIN PointTolerances tol ON tol.nPointUID = p.nPointUID
						LEFT JOIN PointExLogicals pel ON pel.nPointUID = p.nPointUID
					WHERE
						csr.nCallSheetResultUID = @nCallSheetResultUID
					AND
						p.lDeleted = 0 AND p.lActive <> 0
					AND
						csr.lDeleted = 0 AND csr.lActive <> 0
				);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_Classic]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_Classic]'
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_Classic]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_Classic]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_Classic]'

		EXEC sp_executesql N'/********************************************************************************
        udf_GetMETCAL_Results_Classic
        Gets the MET/CAL results data for the Classic view

        Parameters:
        @nCallSheetResultUID - UID for call sheet result record

        (C) 2011-2022 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
        05/22/2012  EdW     Initially created
        06/08/2012  EdW     Added p.nPointUID, COALESCE for
                            pes.cField009, and modifed WHERE
        08/17/2012  MM      Excluded deleted records
        09/04/2012  MM      COALESCE point ordinal (may be NULL now)
        03/18/2013  MM      Added csr.cDescription for tagged procedures
                            Exclude deleted call sheet results
        04/08/2013  MM      Return numbers as numbers
                            Return NULL values as NULL
        08/14/2013  MM      Changed parameter to be work order result
        07/02/2014  MM      Format numeric values with the correct separator
        04/04/2016  MM      Changes for GUIDs
        09/21/2016  MM      Removed parent record fields from the data

                NOTES: All of the statements that make up one fields formatting MUST be on a single line.
                       Test editing results in MET/TEAM after adding or altering any field.
	*********************************************************************************/

		CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_Classic] ( @nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17'' )      -- new record GUID
		RETURNS TABLE
		AS
		RETURN
		(
			SELECT
				p.nPointUID,
				p.nPointOrdinal AS [ROW NUMBER],
				pes.cField009 AS [TEST STEP],
				p.cPointDescription AS [TEST DESCRIPTION],
				COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField010, pen.nField010FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField010UnitUID),'''') AS [FIXQ],
				COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField029, pen.nField029FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField029UnitUID),'''') AS [VARQ],
				COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nLowerLimit, pun.nLowerLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nLowerLimitUnitUID),'''') AS [LOWER_LIMIT],
				COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUpperLimit, pun.nUpperLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUpperLimitUnitUID),'''') AS [UPPER_LIMIT],
				COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nError, tol.nErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nErrorUnitUID),'''') AS [ERROR_VALUE],
				p.cPointPassFailStatus AS [TEST STATUS],
				p.cCondition AS [CONDITION],
				pes.cField011 AS [TUR],
				p.cRemarks AS [REMARK]
			FROM
				CallSheetResults csr
				LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
				LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
				LEFT JOIN PointExNumerics pen ON pen.nPointUID = p.nPointUID
				LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
				LEFT JOIN PointTolerances tol ON tol.nPointUID = p.nPointUID
			WHERE
				csr.nCallSheetResultUID = @nCallSheetResultUID
			AND
				p.lDeleted = 0 AND p.lActive <> 0
			AND
				csr.lDeleted = 0 AND csr.lActive <> 0
		);

		/*  RUN TEST

			DECLARE @nCallSheetResultUID [uniqueidentifier]

			SET @nCallSheetResultUID = 981157000013037

			SELECT *
			FROM
			dbo.udf_GetMETCAL_Results_Classic(@nCallSheetResultUID) ORDER BY 1,2

		*/'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_FullData]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_FullData]'
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_FullData]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_FullData]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_FullData]'

		EXEC sp_executesql N'/****************************************************************
        udf_GetMETCAL_Results_FullData
        Gets the MET/CAL results for the Full Data view

        Parameters:
        @nCallSheetResultUID - UID for call sheet result record

        (C) 2011-2022 Fluke Calibration
        -----------------------------------------------------------------
        CHANGE HISTORY
        05/22/2012  EdW     Initially created
        06/08/2012  EdW     Added p.nPointUID and modifed WHERE
        08/17/2012  MM      Excluded deleted records
        09/04/2012  MM      COALESCE point ordinal, nClaim (may be NULL now)
        09/11/2012  MM      COALESCE nSetTime,nCoverageFactor,nSystemCoverageFactor,
                            nConfidenceLevel,nReadingErrorPercent,nReadingErrorReferencePercent,
                            nFullScaleErrorPercent,nFullScaleErrorReferencePercent,nSetErrorPercent,
                            nSetFullScaleErrorPercent,nToleranceErrorPercent,nChiSquared
        04/08/2013  MM      Return numbers as numbers
                            Return NULL values as NULL
        08/14/2013  MM      Changed parameter to be work order result
        05/16/2014  MM      References for ftol3 and utol3 were crossed
        07/02/2014  MM      Format numeric values with the correct separator
        10/22/2015  MM      Added ManualTemplateRow
        02/25/2016  MM      Added Data Condition
        04/04/2016  MM      Changed for GUIDs
        09/21/2016  MM      Removed parent record fields from the data
        12/15/2021  AC      Changed ToleranceErrorPercent field to return >500 % when nToleranceErrorPercent > 500
		04/11/2022  AC      Place all nToleranceErrorPercent statements on a single line to support Editing Results

                NOTES: All of the statements that make up one fields formatting MUST be on a single line.
                       Test editing results in MET/TEAM after adding or altering any field.
	*******************************************************************************/

	CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_FullData] (
		@nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
	    )
	RETURNS TABLE
	AS
	RETURN
	(
		SELECT
			p.nPointUID,
			COALESCE(mt.cTemplateName, '''') + ''  '' + COALESCE(mtr.cDescription, '''') AS [ManualTemplateRow],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUT, p.nUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTUnitUID),'''') AS [UUT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nReference, p.nReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nReferenceUnitUID),'''') AS [Reference],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nCardinalPoint, p.nCardinalPointFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nCardinalPointUnitUID),'''') AS [CardinalPoint],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nCorrection, p.nCorrectionFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nCorrectionUnitUID),'''') AS [Correction],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUTRange, p.nUUTRangeFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTRangeUnitUID),'''') AS [UUTRange],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nSystemAccuracy, p.nSystemAccuracyFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nSystemAccuracyUnitUID),'''') AS [SystemAccuracy],
			p.nPointOrdinal,
			p.tPointDateTime,
			p.cPointLabel,
			p.cPointStatusFlags,
			p.cPointPassFailStatus,
			p.cFunctionSelectCode,
			p.cPointDescription,
			p.cRemarks,
			p.cOverrideRemarks,
			p.cDesignation,
			p.cTagId,
			p.nSetTime,
			p.cCondition,
			p.nClaim,
			p.lAccredited,
			p.lPrinted,
			p.lUUTIsFixed,
			p.lOverride,
			p.lHeader,
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField001, pen.nField001FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField001UnitUID),'''') AS [Field001],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField002, pen.nField002FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField002UnitUID),'''') AS [Field002],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField003, pen.nField003FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField003UnitUID),'''') AS [Field003],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField004, pen.nField004FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField004UnitUID),'''') AS [Field004],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField005, pen.nField005FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField005UnitUID),'''') AS [Field005],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField006, pen.nField006FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField006UnitUID),'''') AS [Field006],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField007, pen.nField007FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField007UnitUID),'''') AS [Field007],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField008, pen.nField008FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField008UnitUID),'''') AS [Field008],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField009, pen.nField009FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField009UnitUID),'''') AS [Field009],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField010, pen.nField010FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField010UnitUID),'''') AS [Field010],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField011, pen.nField011FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField011UnitUID),'''') AS [Field011],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField012, pen.nField012FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField012UnitUID),'''') AS [Field012],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField013, pen.nField013FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField013UnitUID),'''') AS [Field013],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField014, pen.nField014FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField014UnitUID),'''') AS [Field014],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField015, pen.nField015FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField015UnitUID),'''') AS [Field015],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField016, pen.nField016FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField016UnitUID),'''') AS [Field016],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField017, pen.nField017FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField017UnitUID),'''') AS [Field017],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField018, pen.nField018FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField018UnitUID),'''') AS [Field018],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField019, pen.nField019FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField019UnitUID),'''') AS [Field019],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField020, pen.nField020FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField020UnitUID),'''') AS [Field020],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField021, pen.nField021FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField021UnitUID),'''') AS [Field021],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField022, pen.nField022FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField022UnitUID),'''') AS [Field022],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField023, pen.nField023FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField023UnitUID),'''') AS [Field023],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField024, pen.nField024FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField024UnitUID),'''') AS [Field024],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField025, pen.nField025FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField025UnitUID),'''') AS [Field025],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField026, pen.nField026FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField026UnitUID),'''') AS [Field026],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField027, pen.nField027FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField027UnitUID),'''') AS [Field027],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField028, pen.nField028FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField028UnitUID),'''') AS [Field028],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField029, pen.nField029FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField029UnitUID),'''') AS [Field029],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField030, pen.nField030FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField030UnitUID),'''') AS [Field030],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField031, pen.nField031FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField031UnitUID),'''') AS [Field031],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField032, pen.nField032FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField032UnitUID),'''') AS [Field032],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField033, pen.nField033FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField033UnitUID),'''') AS [Field033],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField034, pen.nField034FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField034UnitUID),'''') AS [Field034],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField035, pen.nField035FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField035UnitUID),'''') AS [Field035],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField036, pen.nField036FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField036UnitUID),'''') AS [Field036],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField037, pen.nField037FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField037UnitUID),'''') AS [Field037],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField038, pen.nField038FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField038UnitUID),'''') AS [Field038],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField039, pen.nField039FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField039UnitUID),'''') AS [Field039],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField040, pen.nField040FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField040UnitUID),'''') AS [Field040],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField041, pen.nField041FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField041UnitUID),'''') AS [Field041],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField042, pen.nField042FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField042UnitUID),'''') AS [Field042],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField043, pen.nField043FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField043UnitUID),'''') AS [Field043],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField044, pen.nField044FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField044UnitUID),'''') AS [Field044],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField045, pen.nField045FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField045UnitUID),'''') AS [Field045],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField046, pen.nField046FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField046UnitUID),'''') AS [Field046],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField047, pen.nField047FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField047UnitUID),'''') AS [Field047],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField048, pen.nField048FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField048UnitUID),'''') AS [Field048],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField049, pen.nField049FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField049UnitUID),'''') AS [Field049],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField050, pen.nField050FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField050UnitUID),'''') AS [Field050],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField051, pen.nField051FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField051UnitUID),'''') AS [Field051],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField052, pen.nField052FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField052UnitUID),'''') AS [Field052],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField053, pen.nField053FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField053UnitUID),'''') AS [Field053],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField054, pen.nField054FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField054UnitUID),'''') AS [Field054],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField055, pen.nField055FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField055UnitUID),'''') AS [Field055],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField056, pen.nField056FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField056UnitUID),'''') AS [Field056],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField057, pen.nField057FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField057UnitUID),'''') AS [Field057],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField058, pen.nField058FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField058UnitUID),'''') AS [Field058],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField059, pen.nField059FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField059UnitUID),'''') AS [Field059],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField060, pen.nField060FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField060UnitUID),'''') AS [Field060],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nGuardBandLowerUnitUID),'''') AS [GuardBandLower],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nGuardBandUpperUnitUID),'''') AS [GuardBandUpper],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertainty, pun.nUncertaintyFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyUnitUID),'''') AS [Uncertainty],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyExpandedUnitUID),'''') AS [UncertaintyExpanded],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyDominant, pun.nUncertaintyDominantFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyDominantUnitUID),'''') AS [UncertaintyDominant],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyStandardUnitUID),'''') AS [UncertaintyStandard],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nLowerLimit, pun.nLowerLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nLowerLimitUnitUID),'''') AS [LOWER_LIMIT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUpperLimit, pun.nUpperLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUpperLimitUnitUID),'''') AS [UPPER_LIMIT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter1, pun.nUncertaintyParameter1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter1UnitUID),'''') AS [UncertaintyParameter1],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter2, pun.nUncertaintyParameter2FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter2UnitUID),'''') AS [UncertaintyParameter2],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter3, pun.nUncertaintyParameter3FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter3UnitUID),'''') AS [UncertaintyParameter3],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter4, pun.nUncertaintyParameter4FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter4UnitUID),'''') AS [UncertaintyParameter4],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter5, pun.nUncertaintyParameter5FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter5UnitUID),'''') AS [UncertaintyParameter5],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter6, pun.nUncertaintyParameter6FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter6UnitUID),'''') AS [UncertaintyParameter6],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter7, pun.nUncertaintyParameter7FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter7UnitUID),'''') AS [UncertaintyParameter7],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter8, pun.nUncertaintyParameter8FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter8UnitUID),'''') AS [UncertaintyParameter8],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter9, pun.nUncertaintyParameter9FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter9UnitUID),'''') AS [UncertaintyParameter9],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter10, pun.nUncertaintyParameter10FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter10UnitUID),'''') AS [UncertaintyParameter10],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nModifier1, pun.nModifier1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nModifier1UnitUID),'''') AS [Modifier1],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nModifier2, pun.nModifier2FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nModifier2UnitUID),'''') AS [Modifier2],
		    COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nS1, pun.nS1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nS1UnitUID),'''') AS [S1],
		    COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nS2, pun.nS2FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nS2UnitUID),'''') AS [S2],
			pun.cGuardBandMethod,
			pun.cUncertaintyMethod,
			pun.nCoverageFactor,
			pun.nSystemCoverageFactor,
			pun.nConfidenceLevel,
			pun.cStudentsT,
			pun.cSensitivity1,
			pun.cSensitivity2,
			pun.cSensitivity3,
			pun.cSensitivity4,
			pun.cSensitivity5,
			pun.cSensitivity6,
			pun.cSensitivity7,
			pun.cSensitivity8,
			pun.cSensitivity9,
			pun.cSensitivity10,
			pun.cDegreesOfFreedom1,
			pun.cDegreesOfFreedom2,
			pun.cDegreesOfFreedom3,
			pun.cDegreesOfFreedom4,
			pun.cDegreesOfFreedom5,
			pun.cDegreesOfFreedom6,
			pun.cDegreesOfFreedom7,
			pun.cDegreesOfFreedom8,
			pun.cDegreesOfFreedom9,
			pun.cDegreesOfFreedom10,
			pun.cEquilibrationParameters,
			pun.lStudentsT,
			pun.lDominant,
			pun.lWelchSatterthwaite,
			pel.lField001,
			pel.lField002,
			pel.lField003,
			pel.lField004,
			pel.lField005,
			pel.lField006,
			pel.lField007,
			pel.lField008,
			pel.lField009,
			pel.lField010,
			pel.lField011,
			pel.lField012,
			pel.lField013,
			pel.lField014,
			pel.lField015,
			pel.lField016,
			pel.lField017,
			pel.lField018,
			pel.lField019,
			pel.lField020,
			pel.lField021,
			pel.lField022,
			pel.lField023,
			pel.lField024,
			pel.lField025,
			pel.lField026,
			pel.lField027,
			pel.lField028,
			pel.lField029,
			pel.lField030,
			pel.lField031,
			pel.lField032,
			pel.lField033,
			pel.lField034,
			pel.lField035,
			pel.lField036,
			pel.lField037,
			pel.lField038,
			pel.lField039,
			pel.lField040,
			pel.lField041,
			pel.lField042,
			pel.lField043,
			pel.lField044,
			pel.lField045,
			pel.lField046,
			pel.lField047,
			pel.lField048,
			pel.lField049,
			pel.lField050,
			pel.lField051,
			pel.lField052,
			pel.lField053,
			pel.lField054,
			pel.lField055,
			pel.lField056,
			pel.lField057,
			pel.lField058,
			pel.lField059,
			pel.lField060,
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nTolerance, tol.nToleranceFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nToleranceUnitUID),'''') AS [Tolerance],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nTolerancePositiveUnitUID),'''') AS [TolerancePositive],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nToleranceNegativeUnitUID),'''') AS [ToleranceNegative],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nReferenceTolerance, tol.nReferenceToleranceFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nReferenceToleranceUnitUID),'''') AS [ReferenceTolerance],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nError, tol.nErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nErrorUnitUID),'''') AS [Error],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceError, tol.nToleranceErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nToleranceErrorUnitUID),'''') AS [ToleranceError],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nReadingErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nReadingErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [ReadingErrorPercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nReadingErrorReferencePercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nReadingErrorReferencePercent IS NULL THEN '''' ELSE '' %'' END AS [ReadingErrorReferencePercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nFullScaleErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nFullScaleErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [FullScaleErrorPercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nFullScaleErrorReferencePercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nFullScaleErrorReferencePercent IS NULL THEN '''' ELSE '' %'' END AS [FullScaleErrorReferencePercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nSetErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nSetErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [SetErrorPercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nSetFullScaleErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nSetFullScaleErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [SetFullScaleErrorPercent],
			CASE WHEN tol.nToleranceErrorPercent > 500 THEN ''>500 %'' ELSE COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nToleranceErrorPercent IS NULL THEN '''' ELSE '' %'' END END AS [ToleranceErrorPercent],
			tol.cToleranceReference,
			pes.cField001,
			pes.cField002,
			pes.cField003,
			pes.cField004,
			pes.cField005,
			pes.cField006,
			pes.cField007,
			pes.cField008,
			pes.cField009,
			pes.cField010,
			pes.cField011,
			pes.cField012,
			pes.cField013,
			pes.cField014,
			pes.cField015,
			pes.cField016,
			pes.cField017,
			pes.cField018,
			pes.cField019,
			pes.cField020,
			pes.cField021,
			pes.cField022,
			pes.cField023,
			pes.cField024,
			pes.cField025,
			pes.cField026,
			pes.cField027,
			pes.cField028,
			pes.cField029,
			pes.cField030,
			pes.cField031,
			pes.cField032,
			pes.cField033,
			pes.cField034,
			pes.cField035,
			pes.cField036,
			pes.cField037,
			pes.cField038,
			pes.cField039,
			pes.cField040,
			pes.cField041,
			pes.cField042,
			pes.cField043,
			pes.cField044,
			pes.cField045,
			pes.cField046,
			pes.cField047,
			pes.cField048,
			pes.cField049,
			pes.cField050,
			pes.cField051,
			pes.cField052,
			pes.cField053,
			pes.cField054,
			pes.cField055,
			pes.cField056,
			pes.cField057,
			pes.cField058,
			pes.cField059,
			pes.cField060,
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nMinimumUUT, stat.nMinimumUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nMinimumUUTUnitUID),'''') AS [MinimumUUT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nMaximumUUT, stat.nMaximumUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nMaximumUUTUnitUID),'''') AS [MaximumUUT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nMinimumReference, stat.nMinimumReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nMinimumReferenceUnitUID),'''') AS [MinimumReference],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nMaximumReference, stat.nMaximumReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nMaximumReferenceUnitUID),'''') AS [MaximumReference],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nUUTStandardDeviation, stat.nUUTStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nUUTStandardDeviationUnitUID),'''') AS [UUTStandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nUUTRawStandardDeviation, stat.nUUTRawStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nUUTRawStandardDeviationUnitUID),'''') AS [UUTRawStandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nReferenceStandardDeviation, stat.nReferenceStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nReferenceStandardDeviationUnitUID),'''') AS [ReferenceStandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nReference2StandardDeviation, stat.nReference2StandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nReference2StandardDeviationUnitUID),'''') AS [Reference2StandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nReferenceRawStandardDeviation, stat.nReferenceRawStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nReferenceRawStandardDeviationUnitUID),'''') AS [ReferenceRawStandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nReferenceRaw2StandardDeviation, stat.nReferenceRaw2StandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nReferenceRaw2StandardDeviationUnitUID),'''') AS [ReferenceRaw2StandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nSampleRate, stat.nSampleRateFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nSampleRateUnitUID),'''') AS [SampleRate],
			stat.nNumberOfSamplesReference,
			stat.nNumberOfSamplesUUT,
			stat.nNumberOfSamplesDiscarded,
			stat.nChiSquared,
			stat.lNoisy,
			stat.lReliable
		FROM
			CallSheetResults csr
			LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN PointExNumerics pen ON pen.nPointUID = p.nPointUID
			LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
			LEFT JOIN PointExLogicals pel ON pel.nPointUID = p.nPointUID
			LEFT JOIN PointTolerances tol ON tol.nPointUID = p.nPointUID
			LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
			LEFT JOIN PointStatistics stat ON stat.nPointUID = p.nPointUID
			LEFT JOIN ManualTemplateRows mtr ON p.nManualTemplateRowUID = mtr.nManualTemplateRowUID
			LEFT JOIN ManualTemplates mt ON mtr.nManualTemplateUID = mt.nManualTemplateUID
		WHERE
			csr.nCallSheetResultUID = @nCallSheetResultUID
		AND
			p.lDeleted = 0 AND p.lActive <> 0
	);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MeasUncert]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_MeasUncert]'
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_MeasUncert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MeasUncert]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_MeasUncert]'

		EXEC sp_executesql N'/******************************************************************************
        udf_GetMETCAL_Results_MeasUncert
        Gets the MET/CAL results for the Measurement Uncertainty view

        Parameters:
        @nCallSheetResultUID - UID for call sheet result record

        (C) 2011-2022 Fluke Calibration
        -----------------------------------------------------------------
        CHANGE HISTORY
        05/22/2012  EdW     Initially created
        06/08/2012  EdW     Added p.nPointUID, COALESCE for pes.cField009,
                            and modifed WHERE
        08/17/2012  MM      Excluded deleted records
        09/04/2012  MM      COALESCE point ordinal (may be NULL now)
        09/11/2012  MM      COALESCE nCoverageFactor
        03/18/2013  MM      Added csr.cDescription for tagged procedures
                            Exclude deleted call sheet results
        04/08/2013  MM      Return numbers as numbers
                            Return NULL values as NULL
        08/14/2013  MM      Changed parameter to be work order result
        07/02/2014  MM      Format numeric values with the correct separator
        04/04/2016  MM      Changes for GUIDs
        09/21/2016  MM      Removed parent record fields from the data

                NOTES: All of the statements that make up one fields formatting MUST be on a single line.
                       Test editing results in MET/TEAM after adding or altering any field.
	********************************************************************************/

	CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_MeasUncert] (
		@nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
	    )
	RETURNS TABLE
	AS
	RETURN
	(
		SELECT
			p.nPointUID,
			p.nPointOrdinal AS [ROW NUMBER],
			pes.cField009 AS [TEST STEP],
			p.cPointDescription AS [TEST DESCRIPTION],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyStandardUnitUID),'''') AS [STD_UNCERT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyExpandedUnitUID),'''') AS [EXP_UNCERT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nCoverageFactor,[dbo].[udf_GET_nFormatUIDFromScale](2)),'''') AS [COVERAGE FACTOR],
			pun.cUncertaintyMethod AS [UNCERTAINTY METHOD],
			ps.nNumberOfSamplesUUT AS [NUMBER OF MEASUREMENTS],
			COALESCE([dbo].[udf_GET_FormattedValueEx](ps.nUUTStandardDeviation, ps.nUUTStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](ps.nUUTStandardDeviationUnitUID),'''') AS [STANDARD DEVIATION]
		FROM
			CallSheetResults csr
			LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
			LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
			LEFT JOIN PointStatistics ps ON ps.nPointUID = p.nPointUID
		WHERE
			csr.nCallSheetResultUID = @nCallSheetResultUID
		AND
			p.lDeleted = 0 AND p.lActive <> 0
		AND
			csr.lDeleted = 0 AND csr.lActive <> 0
	);


	/*  RUN TEST

		DECLARE @nCallSheetResultUID [uniqueidentifier]

		SET @nCallSheetResultUID = 981157000013037

		SELECT *
		FROM
		dbo.udf_GetMETCAL_Results_MeasUncert(@nCallSheetResultUID) ORDER BY 1,2

	*/'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_ProcedureSteps]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_ProcedureSteps]'
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_ProcedureSteps]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_ProcedureSteps]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_ProcedureSteps]'

		EXEC sp_executesql N'/*******************************************************************************
        udf_GetMETCAL_Results_ProcedureSteps
        Gets the MET/CAL results data for the Procedure Steps view

        Parameters:
        @nCallSheetResultUID - UID for call sheet result record

        (C) 2011-2022 Fluke Calibration
    -----------------------------------------------------------------
        CHANGE HISTORY
        05/22/2012  EdW      Initially created
        06/08/2012  EdW      Added p.nPointUID, COALESCE for pes.cField009,
                             and modifed WHERE
        08/17/2012  MM       Excluded deleted records
        09/04/2012  MM       COALESCE point ordinal (may be NULL now)
        03/18/2013  MM       Added csr.cDescription for tagged procedures
                             Exclude deleted call sheet results
        08/14/2013  MM       Changed parameter to be work order result
        07/02/2014  MM       Format numeric values with the correct separator
        04/04/2016  MM       Changes for GUIDs
        09/21/2016  MM      Removed parent record fields from the data

                NOTES: All of the statements that make up one fields formatting MUST be on a single line.
                       Test editing results in MET/TEAM after adding or altering any field.
	*********************************************************************************/

	CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_ProcedureSteps] (
		@nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
	    )
	RETURNS TABLE
	AS
	RETURN
	(
		SELECT
			p.nPointUID,
			p.nPointOrdinal AS [ROW NUMBER],
			pes.cField009 AS [TEST STEP],
			p.cPointDescription AS [TEST DESCRIPTION],
			p.cPointPassFailStatus AS [TEST STATUS],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField010, pen.nField010FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField010UnitUID),'''') AS [FIXQ],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField029, pen.nField029FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField029UnitUID),'''') AS [VARQ],
			p.cFunctionSelectCode AS [FUNCTION SELECT CODE],
			p.cPointLabel AS [RESULT TYPE],
			pes.cField011 AS [TUR]
		FROM
			CallSheetResults csr
			LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
			LEFT JOIN PointExNumerics pen ON pen.nPointUID = p.nPointUID
		WHERE
			csr.nCallSheetResultUID = @nCallSheetResultUID
		AND
			p.lDeleted = 0 AND p.lActive <> 0
		AND
			csr.lDeleted = 0 AND csr.lActive <> 0
	);


	/*  RUN TEST

		DECLARE @nCallSheetResultUID [uniqueidentifier]

		SET @nCallSheetResultUID = 40343000000001

		SELECT *
		FROM
		dbo.udf_GetMETCAL_Results_ProcedureSteps(@nCallSheetResultUID) ORDER BY 1,2

	*/'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	

	--MTM-7751
	IF OBJECT_ID(N'[dbo].[udf_GetCOMPASS_Results]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetCOMPASS_Results]'
		DROP FUNCTION [dbo].[udf_GetCOMPASS_Results]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[udf_GetCOMPASS_Results]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetCOMPASS_Results]'

		EXEC sp_executesql N'
	/****************************************************************
		udf_GetCOMPASS_Results
		Gets the COMPASS results
			paramters:
		@nCallSheetResultUID - call sheet result identifier

		(C) 2014-22 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		05/11/2014	MM		Initially created
		04/04/2016  MM		Changes for GUIDs
		04/18/2022  KW		Added User Defined, Aux and String data fields
	*****************************************************************/

	CREATE FUNCTION [dbo].[udf_GetCOMPASS_Results] (
		@nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
	    )
	RETURNS TABLE
	AS
	RETURN
		(
		SELECT
			p.nPointUID,
			COALESCE(pes.cField009,'''') AS [ID100001],
			--'''' AS [ID100002],
			--'''' AS [ID100003],
			-- [ID100002] + '' '' + [ID100003]
			COALESCE(p.tPointDateTime,'''') AS [tPointDateTime],
			'''' AS [ID100004],
			COALESCE(p.cPointPassFailStatus,'''') AS [ID100005],
			COALESCE(pes.cField021,'''') AS [ID100006],
			COALESCE(pes.cField022,'''') AS [ID100007],
			COALESCE(pes.cField023,'''') AS [ID100008],
			COALESCE(pes.cField024,'''') AS [ID100009],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nCardinalPoint, p.nCardinalPointFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nCardinalPointUnitUID),'''') AS [ID100010],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pa.nAmbientPressure, pa.nAmbientPressureFormatUID) + '' '' + [dbo].[udf_GET_Unit](pa.nAmbientPressureUnitUID),'''') AS [ID100011],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pa.nAmbientTemperature, pa.nAmbientTemperatureFormatUID) + '' '' + [dbo].[udf_GET_Unit](pa.nAmbientTemperatureUnitUID),'''') AS [ID100012],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pa.nAmbientHumidity, pa.nAmbientHumidityFormatUID) + '' '' + [dbo].[udf_GET_Unit](pa.nAmbientHumidityUnitUID),'''') AS [ID100013],
			'''' AS [ID100014],
			'''' AS [ID100015],
			'''' AS [ID100016],
			'''' AS [ID200001],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nReference, p.nReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nReferenceUnitUID),'''') AS [ID200002],
			'''' AS [ID200003],
			'''' AS [ID200004],
			'''' AS [ID200005],
			'''' AS [ID200006],
			'''' AS [ID200007],
			'''' AS [ID200008],
			'''' AS [ID200009],
			'''' AS [ID200010],
			'''' AS [ID200011],
			'''' AS [ID200012],
			'''' AS [ID200013],
			'''' AS [ID200014],
			CASE WHEN COALESCE(pt.cToleranceReference,'''') = '''' THEN '''' ELSE CASE WHEN ISNUMERIC(pt.cToleranceReference) <> 0 THEN COALESCE([dbo].[udf_GET_FormattedValueEx](pt.cToleranceReference, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') ELSE pt.cToleranceReference END END AS [ID200015],
			'''' AS [ID200016],
			'''' AS [ID200017],
			'''' AS [ID200018],
			'''' AS [ID200082],
			'''' AS [ID200083],
			'''' AS [ID300001],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUT, p.nUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTUnitUID),'''') AS [ID300002],
			--'''' AS [ID300003],
			--'''' AS [ID300004],
			-- ID300004 - ID300003
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUTRange, p.nUUTRangeFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTRangeUnitUID),'''') AS [UUT_Range],
			COALESCE(ps.nNumberOfSamplesUUT,0) AS [ID300005],
			COALESCE([dbo].[udf_GET_FormattedValueEx](ps.nUUTStandardDeviation, ps.nUUTStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](ps.nUUTStandardDeviationUnitUID),'''') AS [ID300006],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField027, pen.nField027FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField027UnitUID),'''') AS [ID300007],
			'''' AS [ID300008],
			'''' AS [ID300009],
			'''' AS [ID300010],
			'''' AS [ID300011],
			'''' AS [ID300012],
			'''' AS [ID300013],
			'''' AS [ID300014],
			'''' AS [ID300016],
			'''' AS [ID300017],
			'''' AS [ID300018],
			'''' AS [ID300082],
			'''' AS [ID300083],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField006, pen.nField006FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField006UnitUID),'''') AS [ID301001],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pt.nError, pt.nErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](pt.nErrorUnitUID),'''') AS [ID301002],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pt.nReadingErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN pt.nReadingErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [ID301003],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pt.nTolerance, pt.nToleranceFormatUID) + '' '' + [dbo].[udf_GET_Unit](pt.nToleranceUnitUID),'''') AS [ID301004],
			'''' AS [ID301005],
			'''' AS [ID301006],
			'''' AS [ID301010],
			'''' AS [ID301011],
			'''' AS [ID301012],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField031, pen.nField031FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField031UnitUID),'''') AS [ID400001],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField032, pen.nField032FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField032UnitUID),'''') AS [ID400002],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField033, pen.nField033FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField033UnitUID),'''') AS [ID400003],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField034, pen.nField034FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField034UnitUID),'''') AS [ID400004],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField035, pen.nField035FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField035UnitUID),'''') AS [ID400005],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField036, pen.nField036FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField036UnitUID),'''') AS [ID400006],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField037, pen.nField037FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField037UnitUID),'''') AS [ID400007],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField038, pen.nField038FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField038UnitUID),'''') AS [ID400008],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField039, pen.nField039FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField039UnitUID),'''') AS [ID400009],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField040, pen.nField040FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField040UnitUID),'''') AS [ID400010],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField041, pen.nField041FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField041UnitUID),'''') AS [ID400011],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField042, pen.nField042FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField042UnitUID),'''') AS [ID400012],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField043, pen.nField043FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField043UnitUID),'''') AS [ID400013],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField044, pen.nField044FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField044UnitUID),'''') AS [ID400014],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField045, pen.nField045FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField045UnitUID),'''') AS [ID400015],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField046, pen.nField046FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField046UnitUID),'''') AS [ID400016],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField047, pen.nField047FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField047UnitUID),'''') AS [ID400017],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField048, pen.nField048FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField048UnitUID),'''') AS [ID400018],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField049, pen.nField049FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField049UnitUID),'''') AS [ID400019],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField050, pen.nField050FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField050UnitUID),'''') AS [ID400020],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField051, pen.nField051FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField051UnitUID),'''') AS [ID410001],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField052, pen.nField052FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField052UnitUID),'''') AS [ID410002],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField053, pen.nField053FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField053UnitUID),'''') AS [ID410003],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField054, pen.nField054FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField054UnitUID),'''') AS [ID410004],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField055, pen.nField055FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField055UnitUID),'''') AS [ID410005],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField056, pen.nField056FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField056UnitUID),'''') AS [ID410006],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField057, pen.nField057FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField057UnitUID),'''') AS [ID410007],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField058, pen.nField058FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField058UnitUID),'''') AS [ID410008],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField059, pen.nField059FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField059UnitUID),'''') AS [ID410009],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField060, pen.nField060FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField060UnitUID),'''') AS [ID410010],
			COALESCE(pes.cField025,'''') AS [ID410501],
			COALESCE(pes.cField026,'''') AS [ID410502],
			COALESCE(pes.cField027,'''') AS [ID410503],
			COALESCE(pes.cField028,'''') AS [ID410504],
			COALESCE(pes.cField029,'''') AS [ID410505],
			COALESCE(pes.cField030,'''') AS [ID410506],
			COALESCE(pes.cField031,'''') AS [ID410507],
			COALESCE(pes.cField032,'''') AS [ID410508],
			COALESCE(pes.cField033,'''') AS [ID410509],
			COALESCE(pes.cField034,'''') AS [ID410510],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pu.nLowerLimit, pu.nLowerLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pu.nLowerLimitUnitUID),'''') AS [Lower_Limit],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pu.nUpperLimit, pu.nUpperLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pu.nUpperLimitUnitUID),'''') AS [Upper_Limit],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pt.nToleranceNegative, pt.nToleranceNegativeFormatUID) + '' '' + [dbo].[udf_GET_Unit](pt.nToleranceNegativeUnitUID),'''') AS [Tol_Neg],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pt.nTolerancePositive, pt.nTolerancePositiveFormatUID) + '' '' + [dbo].[udf_GET_Unit](pt.nTolerancePositiveUnitUID),'''') AS [Tol_Pos],
			COALESCE(ps.lNoisy,0) AS [lNoisy],
			COALESCE(ps.lReliable,-1) AS [lReliable]
		FROM
			[dbo].[Points] p
		LEFT JOIN
			[dbo].[PointAmbients] pa ON pa.nPointUID = p.nPointUID
		LEFT JOIN
			[dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
		LEFT JOIN
			[dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
		LEFT JOIN
			[dbo].[PointStatistics] ps ON ps.nPointUID = p.nPointUID
		LEFT JOIN
			[dbo].[PointTolerances] pt ON pt.nPointUID = p.nPointUID
		LEFT JOIN
			[dbo].[PointUncertainties] pu ON pu.nPointUID = p.nPointUID
		WHERE
			p.nCallSheetResultUID = @nCallSheetResultUID
	);
'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-->>MTM-7649<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[AuditLink] WHERE [nAuditLinkUID] = '049DDB9B-DEC7-4277-90AD-8799470C384D')
	BEGIN
		PRINT 'Adding audit link'

		INSERT INTO [dbo].[AuditLink] ([nAuditLinkUID],[cColumnName],[cTableName],[cReturnValue],[mCustomSelect],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('049DDB9B-DEC7-4277-90AD-8799470C384D','nPromptTypeUID','PromptTypes','AuditDisplay',NULL,-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220420 21:45:16.007', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220420 21:45:16.007', '20220420 21:45:16.007', NULL, NULL)

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END

	IF NOT EXISTS(SELECT * FROM [dbo].[AuditLink] WHERE [nAuditLinkUID] = '6538EB0F-F46D-4820-B930-7CC14A41C7E0')
	BEGIN
		PRINT 'Adding audit link'

		INSERT INTO [dbo].[AuditLink] ([nAuditLinkUID],[cColumnName],[cTableName],[cReturnValue],[mCustomSelect],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6538EB0F-F46D-4820-B930-7CC14A41C7E0','nPromptUID','Prompts','AuditDisplay',NULL,-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220420 21:45:16.007', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220420 21:45:16.007', '20220420 21:45:16.007', NULL, NULL)

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END

	IF NOT EXISTS(SELECT * FROM [dbo].[AuditLink] WHERE [nAuditLinkUID] = '45161428-4316-4F9F-904A-582C6A6FC033')
	BEGIN
		PRINT 'Adding audit link'

		INSERT INTO [dbo].[AuditLink] ([nAuditLinkUID],[cColumnName],[cTableName],[cReturnValue],[mCustomSelect],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('45161428-4316-4F9F-904A-582C6A6FC033','nPromptColumnUID','PromptColumns','AuditDisplay',NULL,-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220420 21:45:16.007', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20220420 21:45:16.007', '20220420 21:45:16.007', NULL, NULL)

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'BFCE0B52-07DF-4B73-A5DC-2DB3AF1E71DA')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('BFCE0B52-07DF-4B73-A5DC-2DB3AF1E71DA', N'Prompts', N'nPromptUID', N'Label', N'Prompt UID',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','20220423 00:31:05.587')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '5D2D5D70-7A50-423F-9DB2-683088A4A805')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5D2D5D70-7A50-423F-9DB2-683088A4A805', N'Prompts', N'nPromptTypeUID', N'Label', N'Prompt Type',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','20220423 00:31:05.587')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '62E0E528-FB77-4B85-9213-25C2EFF6338F')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('62E0E528-FB77-4B85-9213-25C2EFF6338F', N'PromptFields', N'nPromptColumnUID', N'Label', N'Database Field',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','20220423 00:31:05.587')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '1D3D57D4-2377-4C72-8D82-A64EAC63012A')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1D3D57D4-2377-4C72-8D82-A64EAC63012A', N'PromptFields', N'nPromptFieldUID', N'Label', N'Prompt Field UID',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','20220423 00:31:05.587')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'C778A490-4B90-4F48-8C93-2B2CF15CBBF2')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('C778A490-4B90-4F48-8C93-2B2CF15CBBF2', N'PromptFields', N'nPromptUID', N'Label', N'Prompt',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220423 00:31:05.587','20220423 00:31:05.587')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-7689<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'D6D05324-9A55-404A-AADC-CCA2C5B2401C')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'D6D05324-9A55-404A-AADC-CCA2C5B2401C', 3, N'PromptFields', NULL, N'_System', 1390, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '18FB2B9D-588C-4892-8C66-9753E2CC24D3')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'18FB2B9D-588C-4892-8C66-9753E2CC24D3', 4, N'PromptFields', N'Prompts will not be updated on Check In', N'_System', 1390, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'ECD2A20A-6166-446B-8926-23391F227F02')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'ECD2A20A-6166-446B-8926-23391F227F02', 3, N'Prompts', NULL, N'_System', 1400, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'DEB27D19-F076-4BAD-B881-E622A6A08C2A')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'DEB27D19-F076-4BAD-B881-E622A6A08C2A', 4, N'Prompts', N'Prompts will not be updated on Check In', N'_System', 1400, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'BE2F80A6-D34C-4544-9F2C-3EB8D3C8021E')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'BE2F80A6-D34C-4544-9F2C-3EB8D3C8021E', 3, N'PromptTypes', N'Do not touch during checkout', N'_System', 1410, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '8E09375E-D858-4430-B298-E7ABDB20C603')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'8E09375E-D858-4430-B298-E7ABDB20C603', 4, N'PromptTypes', NULL, N'_System', 1410, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '7109DBC5-1E1B-460E-9FA9-11D20F11ADF5')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'7109DBC5-1E1B-460E-9FA9-11D20F11ADF5', 3, N'PromptColumns', N'Do not touch during checkout', N'_System', 1420, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '00023BA3-FC25-4DB0-8330-4F3A44CAAA84')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'00023BA3-FC25-4DB0-8330-4F3A44CAAA84', 4, N'PromptColumns', NULL, N'_System', 1420, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = 'B1C51AB4-5FA6-485A-80E3-99DC6DCD7F33')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'B1C51AB4-5FA6-485A-80E3-99DC6DCD7F33', 3, N'PromptTables', N'Do not touch during checkout', N'_System', 1430, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[PackageTables] WHERE nPackageTableUID = '87001D15-D373-4527-96AE-0D434C50C007')
	BEGIN
		PRINT N'Adding Package Table record'

		INSERT INTO [dbo].[PackageTables] (nPackageTableUID, nTransferType, cTableName, cCustomWhere, cAuthority, nOrder, nAddAction, nUpdateAction, nDeleteAction, mNotes,lActive,lDeleted,lApproved,lAdded,nAddFacilityUID,nAddUserUID,tAddTime,nUpdateFacilityUID,nUpdateUserUID,tUpdateTime,tMobileTime,tSystemUpdateTime,nImportUID)
		VALUES (N'87001D15-D373-4527-96AE-0D434C50C007', 4, N'PromptTables', NULL, N'_System', 1430, 0, 0, 0, NULL, 0, 0, -1, 0, N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'dba97adf-f868-459d-8343-de1df0ffb398', N'915f9722-3175-4e4d-a571-4a478e8e5172', N'20220425 16:20:31.970', N'20220425 16:20:31.970',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-->>MTM-7882<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='9DAE3E99-B875-4BB8-91C9-BA692871B2A1')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('9DAE3E99-B875-4BB8-91C9-BA692871B2A1','BatchChange', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220518 16:22:59.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20220518 16:22:59.000','20220518 16:22:59.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '0C8DB41B-D7F4-47E0-B3C2-C140AE5EEF74')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('0C8DB41B-D7F4-47E0-B3C2-C140AE5EEF74', '9DAE3E99-B875-4BB8-91C9-BA692871B2A1', NULL, 'Default', 'Validations', 'cFormName', 50,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20220518 16:22:59.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20220518 16:22:59.000','20220518 16:22:59.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '633DE9FA-DB6E-4471-85C7-501D546FE395')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 10 WHERE [nComboDataUID] = '633DE9FA-DB6E-4471-85C7-501D546FE395'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '011E72AA-E583-49B9-97BC-7816E0F3B453')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 20 WHERE [nComboDataUID] = '011E72AA-E583-49B9-97BC-7816E0F3B453'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'E473E6A2-3938-4A7C-9B4F-3071DCF1BA27')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 30 WHERE [nComboDataUID] = 'E473E6A2-3938-4A7C-9B4F-3071DCF1BA27'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '3F0D4827-9286-4635-9AB5-2EF17470F24B')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 40 WHERE [nComboDataUID] = '3F0D4827-9286-4635-9AB5-2EF17470F24B'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '0C8DB41B-D7F4-47E0-B3C2-C140AE5EEF74')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 50 WHERE [nComboDataUID] = '0C8DB41B-D7F4-47E0-B3C2-C140AE5EEF74'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '350A14C8-63D3-405E-A0D8-8E1802620634')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 60 WHERE [nComboDataUID] = '350A14C8-63D3-405E-A0D8-8E1802620634'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '4569F421-ABEA-473F-B6E1-716520447F6C')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 70 WHERE [nComboDataUID] = '4569F421-ABEA-473F-B6E1-716520447F6C'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '1A2F1E3C-AE38-468B-8C44-1654F8F187E0')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 80 WHERE [nComboDataUID] = '1A2F1E3C-AE38-468B-8C44-1654F8F187E0'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '6EC6D0A9-1F2B-43D3-84D0-4760A527A360')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 90 WHERE [nComboDataUID] = '6EC6D0A9-1F2B-43D3-84D0-4760A527A360'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '0EC6A69A-CC6B-42D1-AF3A-734B433A1AE3')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 100 WHERE [nComboDataUID] = '0EC6A69A-CC6B-42D1-AF3A-734B433A1AE3'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'D0CF4CC7-9014-4774-B7E4-07C592C8FCEA')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 110 WHERE [nComboDataUID] = 'D0CF4CC7-9014-4774-B7E4-07C592C8FCEA'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'D0939FB4-3A57-44FC-9B81-F5E64EA2470E')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 120 WHERE [nComboDataUID] = 'D0939FB4-3A57-44FC-9B81-F5E64EA2470E'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'CED78EF8-568A-48B6-8A70-529AED72EB4E')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 130 WHERE [nComboDataUID] = 'CED78EF8-568A-48B6-8A70-529AED72EB4E'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '6B97B136-8CF2-48A9-BFDB-8EC60139BC32')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 140 WHERE [nComboDataUID] = '6B97B136-8CF2-48A9-BFDB-8EC60139BC32'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '37B3BAE1-38D8-4B7D-ABAB-513F43C92D33')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 150 WHERE [nComboDataUID] = '37B3BAE1-38D8-4B7D-ABAB-513F43C92D33'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '9985D30A-0CC7-4A69-842A-6179F59F4B4E')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 160 WHERE [nComboDataUID] = '9985D30A-0CC7-4A69-842A-6179F59F4B4E'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '676C9093-8675-4239-881D-D4856C64FD16')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 170 WHERE [nComboDataUID] = '676C9093-8675-4239-881D-D4856C64FD16'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '2FB3FEF2-6F40-47D0-9B6D-9A00F5436CEC')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 180 WHERE [nComboDataUID] = '2FB3FEF2-6F40-47D0-9B6D-9A00F5436CEC'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'DA65C610-63EE-4DFC-AAA7-B86215B59553')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 190 WHERE [nComboDataUID] = 'DA65C610-63EE-4DFC-AAA7-B86215B59553'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'ABC963D1-481B-4235-97F0-7E70AB40DB75')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 200 WHERE [nComboDataUID] = 'ABC963D1-481B-4235-97F0-7E70AB40DB75'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'D64C3218-1E97-45AA-AD6B-09AAE4FB179B')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 210 WHERE [nComboDataUID] = 'D64C3218-1E97-45AA-AD6B-09AAE4FB179B'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '8F95A581-08C5-48E8-B1A9-658C52911A54')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 220 WHERE [nComboDataUID] = '8F95A581-08C5-48E8-B1A9-658C52911A54'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'D877AB1F-049F-43CF-8A8B-EAD794E107E8')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 230 WHERE [nComboDataUID] = 'D877AB1F-049F-43CF-8A8B-EAD794E107E8'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '45D3CDC9-A4E8-4C1C-803B-9EAC14B8114B')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 240 WHERE [nComboDataUID] = '45D3CDC9-A4E8-4C1C-803B-9EAC14B8114B'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '60E42E86-9982-45C0-968E-866F61AE07F1')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 250 WHERE [nComboDataUID] = '60E42E86-9982-45C0-968E-866F61AE07F1'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '1AB38E31-22F6-4193-8F66-90FFA3825A38')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 260 WHERE [nComboDataUID] = '1AB38E31-22F6-4193-8F66-90FFA3825A38'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '5C96F9D3-169A-4681-9D34-C428639FFB69')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 270 WHERE [nComboDataUID] = '5C96F9D3-169A-4681-9D34-C428639FFB69'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '313EF616-F186-4DBA-B481-394C528CB4A5')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 280 WHERE [nComboDataUID] = '313EF616-F186-4DBA-B481-394C528CB4A5'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '2446D6E7-0C07-47C8-B618-A43C35A03244')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 290 WHERE [nComboDataUID] = '2446D6E7-0C07-47C8-B618-A43C35A03244'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '80A3CAE1-9F67-43A8-84AA-901B99C2EA64')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 300 WHERE [nComboDataUID] = '80A3CAE1-9F67-43A8-84AA-901B99C2EA64'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '3B3ACA55-D4DE-472A-9D4D-A6D878BCD3A9')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 310 WHERE [nComboDataUID] = '3B3ACA55-D4DE-472A-9D4D-A6D878BCD3A9'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'AE71E3D2-4983-4845-8FF8-364BA4FC72A7')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 320 WHERE [nComboDataUID] = 'AE71E3D2-4983-4845-8FF8-364BA4FC72A7'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '47D8D2CC-E096-4C40-BC60-AC74C6FCEE4F')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 330 WHERE [nComboDataUID] = '47D8D2CC-E096-4C40-BC60-AC74C6FCEE4F'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'F2745ACE-C7F7-4677-AC73-CBC6C9FF4744')
	BEGIN
		PRINT N'Updating combo data item'

		UPDATE [dbo].[ComboData] SET [nOrder] = 340 WHERE [nComboDataUID] = 'F2745ACE-C7F7-4677-AC73-CBC6C9FF4744'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	-->>MC-6798<<--
	IF NOT EXISTS( SELECT * FROM sys.indexes WHERE name='IX_Prompts_cPromptName' )
	BEGIN
		PRINT N'Creating index [dbo].[IX_Prompts_cPromptName]';
		
		CREATE UNIQUE INDEX [IX_Prompts_cPromptName] ON [dbo].[Prompts]
		(
			cPromptName ASC
		) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-->>METCON-2405<<--
	IF NOT EXISTS(SELECT * FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE sc.name = 'nUseCount' AND so.name = 'LicenseDetails')
	BEGIN
		
		PRINT N'Dropping extended properties'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lActive'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lActive'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lAdded'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lAdded'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lApproved'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lApproved'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lDeleted'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lDeleted'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nAddFacilityUID'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nAddUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nAddUserUID'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nUpdateFacilityUID'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nUpdateUserUID'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tAddTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tAddTime'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tMobileTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tMobileTime'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tSystemUpdateTime'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tUpdateTime'
		
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[LicenseDetails]'

		IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PK_LicenseDetails1]', 'PK') AND parent_object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [PK_LicenseDetails1]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lActive' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_lActive]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_lActive]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lDeleted' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_lDeleted]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_lDeleted]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lApproved' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_lApproved]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_lApproved]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lAdded' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_lAdded]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_lAdded]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_nAddFacilityUID]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_nAddFacilityUID]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddUserUID' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_nAddUserUID]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_nAddUserUID]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tAddTime' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_tAddTime]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_tAddTime]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_nUpdateFacilityUID]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_nUpdateFacilityUID]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateUserUID' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_nUpdateUserUID]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_nUpdateUserUID]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tUpdateTime' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_tUpdateTime]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_tUpdateTime]

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tMobileTime' AND object_id = OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_LicenseDetails_tMobileTime]', 'D'))
		ALTER TABLE [dbo].[LicenseDetails] DROP CONSTRAINT [DF_LicenseDetails_tMobileTime]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		CREATE TABLE [dbo].[RG_Recovery_1_LicenseDetails]
		(
			[nLicenseDetailUID] [uniqueidentifier] NOT NULL,
			[nUserUID] [uniqueidentifier] NOT NULL,
			[cWorkstation] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[cApplication] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[cModule] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[tLoginTime] [datetime] NOT NULL,
			[cStatus] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[nUseCount] [int] NOT NULL CONSTRAINT [DF_LicenseDetails_nUseCount] DEFAULT ((0)),
			[lActive] [int] NOT NULL CONSTRAINT [DF_LicenseDetails_lActive] DEFAULT ((-1)),
			[lDeleted] [int] NOT NULL CONSTRAINT [DF_LicenseDetails_lDeleted] DEFAULT ((0)),
			[lApproved] [int] NOT NULL CONSTRAINT [DF_LicenseDetails_lApproved] DEFAULT ((0)),
			[lAdded] [int] NOT NULL CONSTRAINT [DF_LicenseDetails_lAdded] DEFAULT ((-1)),
			[nAddFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_LicenseDetails_nAddFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
			[nAddUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_LicenseDetails_nAddUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
			[tAddTime] [datetime] NOT NULL CONSTRAINT [DF_LicenseDetails_tAddTime] DEFAULT (getutcdate()),
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_LicenseDetails_nUpdateFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
			[nUpdateUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_LicenseDetails_nUpdateUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
			[tUpdateTime] [datetime] NOT NULL CONSTRAINT [DF_LicenseDetails_tUpdateTime] DEFAULT (getutcdate()),
			[tMobileTime] [datetime] NOT NULL CONSTRAINT [DF_LicenseDetails_tMobileTime] DEFAULT (getutcdate()),
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
			CONSTRAINT [RG_Recovery_03a7_PK_LicenseDetails1] PRIMARY KEY NONCLUSTERED ([nLicenseDetailUID])
		)

		INSERT INTO [dbo].[RG_Recovery_1_LicenseDetails]([nLicenseDetailUID], [nUserUID], [cWorkstation], [cApplication], [cModule], [tLoginTime], [cStatus], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) SELECT [nLicenseDetailUID], [nUserUID], [cWorkstation], [cApplication], [cModule], [tLoginTime], [cStatus], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID] FROM [dbo].[LicenseDetails]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		DROP TABLE [dbo].[LicenseDetails]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF (OBJECT_ID(N'[dbo].[RG_Recovery_1_LicenseDetails]', 'U') IS NOT NULL) AND (OBJECT_ID(N'[dbo].[LicenseDetails]', 'U') IS NULL)
		EXEC sp_rename N'[dbo].[RG_Recovery_1_LicenseDetails]', N'LicenseDetails', N'OBJECT'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sp_rename N'[dbo].[LicenseDetails].[RG_Recovery_03a7_PK_LicenseDetails1]', N'PK_LicenseDetails1', N'INDEX'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating extended properties'
		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lActive'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=inactive; -1 or 1=active', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lActive'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lAdded'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not added; -1 or 1=added', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lAdded'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lApproved'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not approved; -1 or 1=approved', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lApproved'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lDeleted'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not deleted; -1 or 1=deleted', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'lDeleted'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that added the record', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nAddFacilityUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nAddUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the user that added the record', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nAddUserUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that last updated the record', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nUpdateFacilityUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the last user to update the record', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'nUpdateUserUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tAddTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was added', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tAddTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tMobileTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for Mobile mode', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tMobileTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for the Warehouse', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tSystemUpdateTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated', 'SCHEMA', N'dbo', 'TABLE', N'LicenseDetails', 'COLUMN', N'tUpdateTime'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	
	END


	-->>MTM-7549<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '179ABFDD-7B14-46F9-8A8B-508CB2CFFABB')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('179ABFDD-7B14-46F9-8A8B-508CB2CFFABB', N'CallSheetStandardLink', N'nCallSheetUID', N'Label', N'Work Order',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220523 20:53:42','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220523 20:53:42','20220523 20:53:42')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '052D7F16-B089-4589-A425-26CC7E553F7F')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('052D7F16-B089-4589-A425-26CC7E553F7F', N'CallSheetStandardLink', N'nAssetUID', N'Label', N'Asset',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220523 20:53:42','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220523 20:53:42','20220523 20:53:42')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END			


	-->>MTM-8069<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='78708C00-BA72-4627-8E0F-FD284897C17B')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('78708C00-BA72-4627-8E0F-FD284897C17B','BatchProcess', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20220621 15:25:35.490','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20220621 15:25:35.490','20220621 15:25:35.490', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '9E898016-0F7B-4040-BAC2-D28CBA33C6C1')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('9E898016-0F7B-4040-BAC2-D28CBA33C6C1', '78708C00-BA72-4627-8E0F-FD284897C17B', NULL, 'Default', 'Validations', 'cFormName', 51, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20220621 15:25:35.490','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20220621 15:25:35.490','20220621 15:25:35.490', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	
	
	
	-->>MTM-8300<<--
	IF EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'CF5BB0E0-B37C-4110-81AD-254EF7C91722')
	BEGIN

		IF NOT EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'CF5BB0E0-B37C-4110-81AD-254EF7C91722'
		AND mNotes = N'AFFECTS: MET/CAL workstation configuration files\nACTION: When Active, the workstation configuration files metcal.ini and instrument_configuration.json will be downloaded from the database to the workstation on startup, overwriting the local copies of these files.')
		BEGIN
			PRINT N'Updating system default'

			UPDATE [dbo].[SystemDefaults] SET
				mNotes = N'AFFECTS: MET/CAL workstation configuration files\nACTION: When Active, the workstation configuration files metcal.ini and instrument_configuration.json will be downloaded from the database to the workstation on startup, overwriting the local copies of these files.',
				lDeleted = 0,
				tUpdateTime = '20220712 23:48:35.560',
				tMobileTime = '20220712 23:48:35.560',
				tSystemUpdateTime = NULL
			WHERE
				nSystemDefaultUID = 'CF5BB0E0-B37C-4110-81AD-254EF7C91722'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END
	
	
	-->>MTM-4227 - keep this in the last spot on the script<<--
	IF OBJECT_ID(N'[dbo].[AuditHistory]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[AuditHistory]'
	IF OBJECT_ID(N'[dbo].[AuditHistory2]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[AuditHistory2]';
	IF OBJECT_ID(N'[dbo].[Ver_8_Config_Vw]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[Ver_8_Config_Vw]';
	IF OBJECT_ID(N'[dbo].[Ver_8_Stds_Vw]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[Ver_8_Stds_Vw]';
	IF OBJECT_ID(N'[dbo].[vw_AlertingEventsCurrentlyDue]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AlertingEventsCurrentlyDue]';
	IF OBJECT_ID(N'[dbo].[vw_AllAssets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllAssets]';
	IF OBJECT_ID(N'[dbo].[vw_AllCallsheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllCallsheets]';
	IF OBJECT_ID(N'[dbo].[vw_AllCallsheetStandards]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllCallsheetStandards]';
	IF OBJECT_ID(N'[dbo].[vw_AllParts]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllParts]';
	IF OBJECT_ID(N'[dbo].[vw_AllReadings]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllReadings]';
	IF OBJECT_ID(N'[dbo].[vw_Assets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Assets]';
	IF OBJECT_ID(N'[dbo].[vw_AssetsWithCallSheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AssetsWithCallSheets]';
	IF OBJECT_ID(N'[dbo].[vw_AssetsWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AssetsWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_AssetsWithServices]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AssetsWithServices]';
	IF OBJECT_ID(N'[dbo].[vw_AssetWithOpenCallsheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AssetWithOpenCallsheets]';
	IF OBJECT_ID(N'[dbo].[vw_AuditDetail]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AuditDetail]';
	IF OBJECT_ID(N'[dbo].[vw_BillingReport]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_BillingReport]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheetLog]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheetLog]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheetReadings]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheetReadings]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheetResultEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheetResultEx]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheets]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheetsWithAttCheck]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheetsWithAttCheck]';
	IF OBJECT_ID(N'[dbo].[vw_ConfigTableColumns]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ConfigTableColumns]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolConflictWIP]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolConflictWIP]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolDelWIP]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolDelWIP]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolDupsWIP]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolDupsWIP]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolDupsWIPCounts]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolDupsWIPCounts]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolDupsWIPLabels]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolDupsWIPLabels]';
	IF OBJECT_ID(N'[dbo].[vw_EMXAuditDetail]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_EMXAuditDetail]';
	IF OBJECT_ID(N'[dbo].[vw_EMXAuditHeader]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_EMXAuditHeader]';
	IF OBJECT_ID(N'[dbo].[vw_EstimateItems]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_EstimateItems]';
	IF OBJECT_ID(N'[dbo].[vw_Estimates]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Estimates]';
	IF OBJECT_ID(N'[dbo].[vw_ExtendedDataDetails]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ExtendedDataDetails]';	
	IF OBJECT_ID(N'[dbo].[vw_Facilities]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Facilities]';
	IF OBJECT_ID(N'[dbo].[vw_FileMd5]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_FileMd5]';
	IF OBJECT_ID(N'[dbo].[vw_Inventory_w_CS_IntervalsReport]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Inventory_w_CS_IntervalsReport]';
	IF OBJECT_ID(N'[dbo].[vw_JobNumberFacilities]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_JobNumberFacilities]';
	IF OBJECT_ID(N'[dbo].[vw_JobNumbers]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_JobNumbers]';
	IF OBJECT_ID(N'[dbo].[vw_LabMetricsTimeSpent]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_LabMetricsTimeSpent]';
	IF OBJECT_ID(N'[dbo].[vw_LabMetricsTurnTimes]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_LabMetricsTurnTimes]';
	IF OBJECT_ID(N'[dbo].[vw_LabMetricsTurnTimesWithBreakdown]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_LabMetricsTurnTimesWithBreakdown]';
	IF OBJECT_ID(N'[dbo].[vw_ManualTemplateInfo]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ManualTemplateInfo]';
	IF OBJECT_ID(N'[dbo].[vw_METCAL_DataPoints]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_METCAL_DataPoints]';
	IF OBJECT_ID(N'[dbo].[vw_OpenCallSheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_OpenCallSheets]';
	IF OBJECT_ID(N'[dbo].[vw_PackageHistory]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PackageHistory]';
	IF OBJECT_ID(N'[dbo].[vw_Parts]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Parts]';
	IF OBJECT_ID(N'[dbo].[vw_PointExNumerics]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointExNumerics]';
	IF OBJECT_ID(N'[dbo].[vw_PointReadings]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointReadings]';
	IF OBJECT_ID(N'[dbo].[vw_Points]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Points]';
	IF OBJECT_ID(N'[dbo].[vw_PointStatistics]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointStatistics]';
	IF OBJECT_ID(N'[dbo].[vw_PointTolerances]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointTolerances]';
	IF OBJECT_ID(N'[dbo].[vw_PointUncertainties]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointUncertainties]';
	IF OBJECT_ID(N'[dbo].[vw_ProblemReports]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ProblemReports]';
	IF OBJECT_ID(N'[dbo].[vw_ProblemReportsWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ProblemReportsWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_Procedures]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Procedures]';
	IF OBJECT_ID(N'[dbo].[vw_ProceduresWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ProceduresWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_ProcedureStandards]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ProcedureStandards]';
	IF OBJECT_ID(N'[dbo].[vw_Prompts]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Prompts]';
	IF OBJECT_ID(N'[dbo].[vw_ServiceTypes1]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ServiceTypes1]';
	IF OBJECT_ID(N'[dbo].[vw_ShipmentItems]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ShipmentItems]';
	IF OBJECT_ID(N'[dbo].[vw_Shipments]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Shipments]';
	IF OBJECT_ID(N'[dbo].[vw_ToolAssignments]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ToolAssignments]';
	IF OBJECT_ID(N'[dbo].[vw_Types]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Types]';
	IF OBJECT_ID(N'[dbo].[vw_UnbilledLabor]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_UnbilledLabor]';
	IF OBJECT_ID(N'[dbo].[vw_WorkOrdersWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_WorkOrdersWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_METCONNECT_RESULTS]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_METCONNECT_RESULTS]';

    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	PRINT N'Updating database version'
	INSERT INTO [dbo].[Version] (
		[nVersionUID]
		,[cVersion]
		,[tInstallDate]
		,[mNote]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
	  )
	  VALUES
	  (
		'59952E38-47DB-4097-A1AA-46361233194A'
		,'3.6.0'
		,'20220601 12:12:12.000'
		,'3.6.0 Release'
		,-1
		,0
		,0
		,0
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20220601 12:12:12.000'
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20220601 12:12:12.000'
		,'20220601 12:12:12.000'
		,NULL
	  )

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	-- Make sure previous version records are inactive
	UPDATE [dbo].[Version] SET lActive = 0, tUpdateTime = '20220601 12:12:12.000', tMobileTime = '20220601 12:12:12.000' WHERE lActive <> 0 AND nVersionUID <> '59952E38-47DB-4097-A1AA-46361233194A'

	IF EXISTS (SELECT * FROM #tmpErrors) ROLLBACK TRANSACTION

	IF @@TRANCOUNT>0 BEGIN
	PRINT 'The database update succeeded'
	COMMIT TRANSACTION
	END
	ELSE PRINT 'The database update failed'

	DROP TABLE #tmpErrors
END
ELSE
	Print N'The database is up-to-date, version 3.6.0'
GO
